
/***********************************************************************/
/*   Analog Output		1                                              */
/***********************************************************************/

BLOCK func3_AO_1
{
	TYPE	FUNCTION;
	NUMBER	5;
}

func3_AO_1_blk_reserve							LIKE VARIABLE	phys_blk_reserve
{
}

VARIABLE func3_AO_1_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[blk_block_object_FUNCTION]		}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_1_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[func_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[func_blk_parent_class_OUTPUT]	}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_1_blk_class
{
	LABEL		[blk_class];
	HELP		[func_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[func_blk_class_AO]		}
	}	
	HANDLING	READ;
}

func3_AO_1_blk_dd_reference						LIKE VARIABLE	phys_blk_dd_reference
{											
}											
											
func3_AO_1_blk_dd_rev							LIKE VARIABLE	phys_blk_dd_rev
{											
}											
											
func3_AO_1_blk_profile							LIKE VARIABLE	phys_blk_profile
{											
}											
											
func3_AO_1_blk_profile_rev						LIKE VARIABLE	phys_blk_profile_rev
{											
}											
											
func3_AO_1_blk_execution_time					LIKE VARIABLE	phys_blk_execution_time
{											
}											
											
func3_AO_1_blk_num_parameters					LIKE VARIABLE	phys_blk_num_parameters
{											
}											
											
func3_AO_1_blk_index_view_1						LIKE VARIABLE	phys_blk_index_view_1
{											
}

func3_AO_1_blk_num_view_lists					LIKE VARIABLE	phys_blk_num_view_lists
{											
}											
											
func3_AO_1_st_rev								LIKE VARIABLE	phys_st_rev
{
	REDEFINE LABEL  "AO_1 ST_REV";											
}
											
func3_AO_1_tag_desc								LIKE VARIABLE	phys_tag_desc
{
	REDEFINE LABEL "AO-1 Tag";
    TYPE                ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}
											
func3_AO_1_strategy								LIKE VARIABLE	phys_strategy
{											
}											
											
func3_AO_1_alert_key								LIKE VARIABLE	phys_alert_key
{											
}

func3_AO_1_target_mode							LIKE VARIABLE	phys_target_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	BLOCK_MODE_AUTO;
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_1_actual_mode							LIKE VARIABLE	phys_actual_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_1_permitted_mode						LIKE VARIABLE	phys_permitted_mode
{
	REDEFINE TYPE		BIT_ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_1_normal_mode							LIKE VARIABLE	phys_normal_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_1_current_state_alarm_sum				LIKE VARIABLE	phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_1_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_1_unreported_state_alarm_sum			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_1_disabled_state_alarm_sum				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func3_AO_1_batch_id
{
	LABEL		[func_batch_id];		
	HELP		[func_batch_id_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_batch_unit
{
	LABEL		[func_batch_unit];		
	HELP		[func_batch_unit_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_batch_operation
{
	LABEL		[func_batch_operation];		
	HELP		[func_batch_operation_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_batch_phase
{
	LABEL		[func_batch_phase];		
	HELP		[func_batch_phase_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    Function Block: Analog Output							           */
/*---------------------------------------------------------------------*/

VARIABLE func3_AO_1_setpoint_value
{
	LABEL		[func_ao_setpoint_value]; 
	HELP		[func_ao_setpoint_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING
		IF (func3_AO_1_target_mode == BLOCK_MODE_AUTO)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}	
}

VARIABLE func3_AO_1_setpoint_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_setpoint_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_1
	}
  	HANDLING	
		IF (func3_AO_1_target_mode == BLOCK_MODE_AUTO)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}	

}

func3_AO_1_setpoint_status_limit            LIKE VARIABLE    func3_AO_1_setpoint_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_1_setpoint_status_quality)
    }
}

VARIABLE func3_AO_1_pv_upper_range_value
{
	LABEL		"Upper [EU(100%)]";
	HELP		[func_pv_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_pv_lower_range_value
{
	LABEL		"Lower [EU(0%)]";
	HELP		[func_pv_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_pv_unit
{
	LABEL		[func_pv_scale_unit];
	HELP		[func_pv_scale_unit_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1342;
/*	  	{ 1342,  [Percent],	[Percent_help]	},
		{ 1005,  [degrees],	[degrees_help]	},
		{ 1013,  [mm],			[mm_help]	},
		{ 1211,  [mA], 		[mA_help] } */
		UNIT_LIST 
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_pv_decimal_point
{
	LABEL		[decimal_point];
	HELP		[decimal_point_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	2;
		{	0,   "0"		},
		{	1,   "1"		},
		{	2,   "2"		},
		{	3,   "3"		},
		{	4,   "4"		},
		{	5,   "5"		},
		{	6,   "6"		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_readback_value
{
	LABEL		[func_ao_readback_value]; 
	HELP		[func_ao_readback_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ;
}


VARIABLE func3_AO_1_readback_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_readback_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING	READ;
}

func3_AO_1_readback_status_limit            LIKE VARIABLE    func3_AO_1_readback_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_1_rcas_in_value
{
	LABEL		[func_rcas_in_value];
	HELP		[func_rcas_in_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_rcas_in_status_quality
{
	LABEL		[status_quality];
	HELP		[func_rcas_in_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_1
	}
	HANDLING	READ & WRITE;
}

func3_AO_1_rcas_in_status_limit            LIKE VARIABLE    func3_AO_1_rcas_in_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_1_rcas_in_status_quality)
    }
}

VARIABLE func3_AO_1_in_channel
{
	LABEL		[MC_channel];
	HELP		[func_channel_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(2)
	{
        DEFAULT_VALUE   1;
        {1,    "Mod_Out_1(TB)"              },
        {2,    "Mod_Out_2(TB)"              },
        {3,    "Mod_Out_3(TB)"              },
        {4,    "Mod_Out_4(TB)"              }
	}
	HANDLING	READ & WRITE;
}


func3_AO_1_out_channel							LIKE VARIABLE	func3_AO_1_in_channel
{
	REDEFINE LABEL [MC_channel];
}

VARIABLE func3_AO_1_fsafe_time
{
	LABEL		[func_ao_fsafe_time];
	HELP		[func_ao_fsafe_time_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_fsafe_type
{
	LABEL		[func_ao_fsafe_type];
	HELP		[func_ao_fsafe_type_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[func_ao_fsafe_type_FAIL_SAFE_VALUE]		},
		{	1,	[func_ao_fsafe_type_STORING_LAST_SETPOINT]	},
		{	2,	[func_ao_fsafe_type_FAIL_SAFE_POSITION]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_fsafe_value
{
	LABEL		[func_ao_fsafe_value];
	HELP		[func_ao_fsafe_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_rcas_out_value
{
	LABEL		[func_rcas_out_value]; 
	HELP		[func_rcas_out_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
}

VARIABLE func3_AO_1_rcas_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_rcas_out_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_RCAS
	}
	HANDLING    READ;
}

func3_AO_1_rcas_out_status_limit            LIKE VARIABLE    func3_AO_1_rcas_out_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_1_position_discrete_value
{
	LABEL		[func_ao_position_discrete_value];
	HELP		[func_ao_position_discrete_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0,	[func_ao_position_discrete_status_NOT_INIT]			},
		{	1,	[func_ao_position_discrete_status_CLOSED]			},
		{	2,	[func_ao_position_discrete_status_OPENED]			},
		{	3,	[func_ao_position_discrete_status_INTERMEDIATE]		}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_1_position_discrete_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_position_discrete_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING READ;
}

func3_AO_1_position_discrete_status_limit            LIKE VARIABLE    func3_AO_1_position_discrete_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_1_setpoint_deviation
{
	LABEL		[func_ao_setpoint_deviation];
	HELP		[func_ao_setpoint_deviation_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	CONSTANT_UNIT	[Percent];
	HANDLING	READ;
}

VARIABLE func3_AO_1_check_back
{
	LABEL		[func_check_back];
	HELP		[func_check_back_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (3)
	{
		{	0,					[dia_OK],				[dia_OK_help]				},
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]		},
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func3_AO_1_check_back_mask
{
	LABEL		[func_check_back_mask];
	HELP		[func_check_back_mask_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (3)
	{
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]		},
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func3_AO_1_simulate_value
{
	LABEL		"Simulate Value";
	HELP		[func_ao_simulate_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_simulate_status_quality
{
	LABEL		[status_quality];
	HELP		[func_simulate_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_1
	}
	HANDLING READ & WRITE;
}

func3_AO_1_simulate_status_limit            LIKE VARIABLE    func3_AO_1_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_1_simulate_status_quality)
    }
}

VARIABLE func3_AO_1_simulation_enabled
{
	LABEL		[func_simulation_enabled];
	HELP		[func_simulation_enabled_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[disabled]		},
		{	1,	[enabled]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_increase_close
{
	LABEL		"Action"; /* [func_ao_increase_close]; */
	HELP		[func_ao_increase_close_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	"Opening" /* [func_ao_increase_close_RISING]	*/	},
		{	1,	"Closing" /* [func_ao_increase_close_FALLING] */	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_out_value
{
	LABEL		[func_out_value];
	HELP		[func_ao_out_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING
		IF ((func3_AO_1_actual_mode == BLOCK_MODE_MAN) || (func3_AO_1_actual_mode == BLOCK_MODE_LO))
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

VARIABLE func3_AO_1_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_out_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		IF ((func3_AO_1_actual_mode == BLOCK_MODE_MAN) || (func3_AO_1_actual_mode == BLOCK_MODE_LO))
		{
			STATUS_INPUT_NO_RCAS
		}
		ELSE {
			STATUS_OUTPUT_NO_RCAS
		}
	}
	POST_EDIT_ACTIONS
	{
		IF ((func3_AO_1_actual_mode == BLOCK_MODE_MAN) || (func3_AO_1_actual_mode == BLOCK_MODE_LO))
		{
			method_set_status_limit_func3_AO_1
		}
	}
	HANDLING
		IF ((func3_AO_1_actual_mode == BLOCK_MODE_MAN) || (func3_AO_1_actual_mode == BLOCK_MODE_LO))
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

func3_AO_1_out_status_limit            LIKE VARIABLE    func3_AO_1_out_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_1_out_upper_range_value
{
	LABEL		"Upper [EU(100%)]";
	HELP		[func_out_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_out_lower_range_value
{
	LABEL		"Lower [EU(0%)]";
	HELP		[func_out_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_1_out_unit
{
	LABEL		[func_out_scale_unit];
	HELP		[func_out_scale_unit_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1342;
		UNIT_LIST 
	}
	HANDLING	READ & WRITE;
}

func3_AO_1_out_decimal_point						LIKE VARIABLE	func3_AO_1_pv_decimal_point
{
}

/***********************************************************************/
/*   Analog Output	 2	                                              */
/***********************************************************************/

BLOCK func3_AO_2
{
	TYPE	FUNCTION;
	NUMBER	6;
}

func3_AO_2_blk_reserve							LIKE VARIABLE	phys_blk_reserve
{
}

VARIABLE func3_AO_2_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[blk_block_object_FUNCTION]		}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_2_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[func_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[func_blk_parent_class_OUTPUT]	}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_2_blk_class
{
	LABEL		[blk_class];
	HELP		[func_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[func_blk_class_AO]		}
	}	
	HANDLING	READ;
}

func3_AO_2_blk_dd_reference						LIKE VARIABLE	phys_blk_dd_reference
{											
}											
											
func3_AO_2_blk_dd_rev							LIKE VARIABLE	phys_blk_dd_rev
{											
}
											
func3_AO_2_blk_profile							LIKE VARIABLE	phys_blk_profile
{											
}											
											
func3_AO_2_blk_profile_rev						LIKE VARIABLE	phys_blk_profile_rev
{											
}											
											
func3_AO_2_blk_execution_time					LIKE VARIABLE	phys_blk_execution_time
{											
}											
											
func3_AO_2_blk_num_parameters					LIKE VARIABLE	phys_blk_num_parameters
{											
}
											
func3_AO_2_blk_index_view_1						LIKE VARIABLE	phys_blk_index_view_1
{											
}

func3_AO_2_blk_num_view_lists					LIKE VARIABLE	phys_blk_num_view_lists
{											
}											
											
func3_AO_2_st_rev								LIKE VARIABLE	phys_st_rev
{
	REDEFINE LABEL  "AO_2 ST_REV";										
}
											
func3_AO_2_tag_desc								LIKE VARIABLE	phys_tag_desc
{
	REDEFINE LABEL "AO-2 Tag";							
    TYPE                ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}											
											
func3_AO_2_strategy								LIKE VARIABLE	phys_strategy
{											
}											
											
func3_AO_2_alert_key								LIKE VARIABLE	phys_alert_key
{											
}

func3_AO_2_target_mode							LIKE VARIABLE	phys_target_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	BLOCK_MODE_AUTO;
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_2_actual_mode							LIKE VARIABLE	phys_actual_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_2_permitted_mode						LIKE VARIABLE	phys_permitted_mode
{
	REDEFINE TYPE		BIT_ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_2_normal_mode							LIKE VARIABLE	phys_normal_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_2_current_state_alarm_sum				LIKE VARIABLE	phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_2_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_2_unreported_state_alarm_sum			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_2_disabled_state_alarm_sum				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func3_AO_2_batch_id
{
	LABEL		[func_batch_id];		
	HELP		[func_batch_id_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_batch_unit
{
	LABEL		[func_batch_unit];		
	HELP		[func_batch_unit_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_batch_operation
{
	LABEL		[func_batch_operation];		
	HELP		[func_batch_operation_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_batch_phase
{
	LABEL		[func_batch_phase];		
	HELP		[func_batch_phase_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    Function Block: Analog Output							           */
/*---------------------------------------------------------------------*/

VARIABLE func3_AO_2_setpoint_value
{
	LABEL		[func_ao_setpoint_value];
	HELP		[func_ao_setpoint_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	
		IF (func3_AO_2_target_mode == BLOCK_MODE_AUTO)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}	

}

VARIABLE func3_AO_2_setpoint_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_setpoint_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_NO_RCAS
	}
 	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_2
	}
 	HANDLING	
		IF (func3_AO_2_target_mode == BLOCK_MODE_AUTO)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}	

}

func3_AO_2_setpoint_status_limit            LIKE VARIABLE    func3_AO_2_setpoint_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_2_setpoint_status_quality)
    }
}

VARIABLE func3_AO_2_pv_upper_range_value
{
	LABEL		"Upper [EU(100%)]";
	HELP		[func_pv_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_pv_lower_range_value
{
	LABEL		"Lower [EU(0%)]";
	HELP		[func_pv_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_pv_unit
{
	LABEL		[func_pv_scale_unit];
	HELP		[func_pv_scale_unit_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1342;
		UNIT_LIST
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_pv_decimal_point
{
	LABEL		[decimal_point];
	HELP		[decimal_point_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	2;
		{	0,   "0"		},
		{	1,   "1"		},
		{	2,   "2"		},
		{	3,   "3"		},
		{	4,   "4"		},
		{	5,   "5"		},
		{	6,   "6"		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_readback_value
{
	LABEL		[func_ao_readback_value]; 
	HELP		[func_ao_readback_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ;
}

VARIABLE func3_AO_2_readback_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_readback_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING	READ;
}

func3_AO_2_readback_status_limit            LIKE VARIABLE    func3_AO_2_readback_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_2_rcas_in_value
{
	LABEL		[func_rcas_in_value];
	HELP		[func_rcas_in_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_rcas_in_status_quality
{
	LABEL		[status_quality];
	HELP		[func_rcas_in_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_2
	}
	HANDLING	READ & WRITE;
}

func3_AO_2_rcas_in_status_limit            LIKE VARIABLE    func3_AO_2_rcas_in_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_2_rcas_in_status_quality)
    }
}

VARIABLE func3_AO_2_in_channel
{
	LABEL		[MC_channel];
	HELP		[func_channel_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(2)
	{
        DEFAULT_VALUE   2;
        {1,    "Mod_Out_1(TB)"              },
        {2,    "Mod_Out_2(TB)"              },
        {3,    "Mod_Out_3(TB)"              },
        {4,    "Mod_Out_4(TB)"              }
	}
	HANDLING	READ & WRITE;
}

func3_AO_2_out_channel							LIKE VARIABLE	func3_AO_2_in_channel
{
	REDEFINE LABEL [MC_channel];
}

VARIABLE func3_AO_2_fsafe_time
{
	LABEL		[func_ao_fsafe_time];
	HELP		[func_ao_fsafe_time_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_fsafe_type
{
	LABEL		[func_ao_fsafe_type];
	HELP		[func_ao_fsafe_type_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[func_ao_fsafe_type_FAIL_SAFE_VALUE]		},
		{	1,	[func_ao_fsafe_type_STORING_LAST_SETPOINT]	},
		{	2,	[func_ao_fsafe_type_FAIL_SAFE_POSITION]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_fsafe_value
{
	LABEL		"Fail Safe Value";
	HELP		[func_ao_fsafe_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_rcas_out_value
{
	LABEL		[func_rcas_out_value];
	HELP		[func_rcas_out_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
}

VARIABLE func3_AO_2_rcas_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_rcas_out_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_RCAS
	}
	HANDLING    READ;
}

func3_AO_2_rcas_out_status_limit            LIKE VARIABLE    func3_AO_2_rcas_out_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_2_position_discrete_value
{
	LABEL		[func_ao_position_discrete_value];
	HELP		[func_ao_position_discrete_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0,	[func_ao_position_discrete_status_NOT_INIT]			},
		{	1,	[func_ao_position_discrete_status_CLOSED]			},
		{	2,	[func_ao_position_discrete_status_OPENED]			},
		{	3,	[func_ao_position_discrete_status_INTERMEDIATE]		}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_2_position_discrete_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_position_discrete_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING READ;
}

func3_AO_2_position_discrete_status_limit            LIKE VARIABLE    func3_AO_2_position_discrete_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_2_setpoint_deviation
{
	LABEL		[func_ao_setpoint_deviation];
	HELP		[func_ao_setpoint_deviation_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	CONSTANT_UNIT	[Percent];
	HANDLING	READ;
}

VARIABLE func3_AO_2_check_back
{
	LABEL		[func_check_back];
	HELP		[func_check_back_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (3)
	{
		{	0,					[dia_OK],				[dia_OK_help]				},
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]		},
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func3_AO_2_check_back_mask
{
	LABEL		[func_check_back_mask];
	HELP		[func_check_back_mask_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (3)
	{
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]		},
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func3_AO_2_simulate_value
{
	LABEL		"Simulate Value";
	HELP		[func_ao_simulate_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_simulate_status_quality
{
	LABEL		[status_quality];
	HELP		[func_simulate_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
        STATUS_INPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_2
	}
	HANDLING READ & WRITE;
}

func3_AO_2_simulate_status_limit            LIKE VARIABLE    func3_AO_2_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_2_simulate_status_quality)
    }
}

VARIABLE func3_AO_2_simulation_enabled
{
	LABEL		[func_simulation_enabled];
	HELP		[func_simulation_enabled_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[disabled]		},
		{	1,	[enabled]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_increase_close
{
	LABEL		"Action"; /*[func_ao_increase_close]; */
	HELP		[func_ao_increase_close_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	"Opening" /* [func_ao_increase_close_RISING]	*/	},
		{	1,	"Closing" /* [func_ao_increase_close_FALLING] */	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_out_value
{
	LABEL		[func_out_value];
	HELP		[func_ao_out_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING
		IF ((func3_AO_2_actual_mode == BLOCK_MODE_MAN) || (func3_AO_2_actual_mode == BLOCK_MODE_LO))
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

VARIABLE func3_AO_2_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_out_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		IF ((func3_AO_2_actual_mode == BLOCK_MODE_MAN) || (func3_AO_2_actual_mode == BLOCK_MODE_LO))
		{
			STATUS_INPUT_NO_RCAS
		}
		ELSE {
			STATUS_OUTPUT_NO_RCAS
		}
	}
	POST_EDIT_ACTIONS
	{
		IF ((func3_AO_2_actual_mode == BLOCK_MODE_MAN) || (func3_AO_2_actual_mode == BLOCK_MODE_LO))
		{
			method_set_status_limit_func3_AO_2
		}
	}
	HANDLING
		IF ((func3_AO_2_actual_mode == BLOCK_MODE_MAN) || (func3_AO_2_actual_mode == BLOCK_MODE_LO))
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

func3_AO_2_out_status_limit            LIKE VARIABLE    func3_AO_2_out_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_2_out_upper_range_value
{
	LABEL		"Upper [EU(100%)]";
	HELP		[func_out_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_out_lower_range_value
{
	LABEL		"Lower [EU(0%)]";
	HELP		[func_out_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_2_out_unit
{
	LABEL		[func_out_scale_unit];
	HELP		[func_out_scale_unit_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1342;
		UNIT_LIST
	}
	HANDLING	READ & WRITE;
}

func3_AO_2_out_decimal_point						LIKE VARIABLE	func3_AO_2_pv_decimal_point
{
}


/***********************************************************************/
/*   AO-3		                                              */
/***********************************************************************/

BLOCK func3_AO_3
{
	TYPE	FUNCTION;
	NUMBER	7;
}

func3_AO_3_blk_reserve							LIKE VARIABLE	phys_blk_reserve
{
}

VARIABLE func3_AO_3_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[blk_block_object_FUNCTION]		}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_3_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[func_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[func_blk_parent_class_OUTPUT]	}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_3_blk_class
{
	LABEL		[blk_class];
	HELP		[func_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[func_blk_class_AO]		}
	}
	HANDLING	READ;
}

func3_AO_3_blk_dd_reference						LIKE VARIABLE	phys_blk_dd_reference
{
}

func3_AO_3_blk_dd_rev							LIKE VARIABLE	phys_blk_dd_rev
{
}

func3_AO_3_blk_profile							LIKE VARIABLE	phys_blk_profile
{
}

func3_AO_3_blk_profile_rev						LIKE VARIABLE	phys_blk_profile_rev
{
}
											
func3_AO_3_blk_execution_time					LIKE VARIABLE	phys_blk_execution_time
{											
}											
											
func3_AO_3_blk_num_parameters					LIKE VARIABLE	phys_blk_num_parameters
{											
}											
											
func3_AO_3_blk_index_view_1						LIKE VARIABLE	phys_blk_index_view_1
{											
}

func3_AO_3_blk_num_view_lists					LIKE VARIABLE	phys_blk_num_view_lists
{											
}											
											
func3_AO_3_st_rev								LIKE VARIABLE	phys_st_rev
{
	REDEFINE LABEL  "AO_3 ST_REV";
}
											
func3_AO_3_tag_desc								LIKE VARIABLE	phys_tag_desc
{
	REDEFINE LABEL "AO-3 Tag";
    TYPE                ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}
											
func3_AO_3_strategy								LIKE VARIABLE	phys_strategy
{											
}											
											
func3_AO_3_alert_key								LIKE VARIABLE	phys_alert_key
{											
}

func3_AO_3_target_mode							LIKE VARIABLE	phys_target_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	BLOCK_MODE_AUTO;
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_3_actual_mode							LIKE VARIABLE	phys_actual_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_3_permitted_mode						LIKE VARIABLE	phys_permitted_mode
{
	REDEFINE TYPE		BIT_ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_3_normal_mode							LIKE VARIABLE	phys_normal_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_3_current_state_alarm_sum				LIKE VARIABLE	phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_3_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_3_unreported_state_alarm_sum			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_3_disabled_state_alarm_sum				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func3_AO_3_batch_id
{
	LABEL		[func_batch_id];		
	HELP		[func_batch_id_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_batch_unit
{
	LABEL		[func_batch_unit];		
	HELP		[func_batch_unit_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_batch_operation
{
	LABEL		[func_batch_operation];		
	HELP		[func_batch_operation_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_batch_phase
{
	LABEL		[func_batch_phase];		
	HELP		[func_batch_phase_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    Function Block: Analog Output							           */
/*---------------------------------------------------------------------*/

VARIABLE func3_AO_3_setpoint_value
{
	LABEL		[func_ao_setpoint_value];
	HELP		[func_ao_setpoint_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	
		IF (func3_AO_3_target_mode == BLOCK_MODE_AUTO)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}	

}

VARIABLE func3_AO_3_setpoint_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_setpoint_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_3
	}
  	HANDLING	
		IF (func3_AO_3_target_mode == BLOCK_MODE_AUTO)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}	

}

func3_AO_3_setpoint_status_limit            LIKE VARIABLE    func3_AO_3_setpoint_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_3_setpoint_status_quality)
    }
}

VARIABLE func3_AO_3_pv_upper_range_value
{
	LABEL		"Upper [EU(100%)]";
	HELP		[func_pv_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_pv_lower_range_value
{
	LABEL		"Lower [EU(0%)]";
	HELP		[func_pv_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_pv_unit
{
	LABEL		[func_pv_scale_unit];
	HELP		[func_pv_scale_unit_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1342;
		UNIT_LIST
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_pv_decimal_point
{
	LABEL		[decimal_point];
	HELP		[decimal_point_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	2;
		{	0,   "0"		},
		{	1,   "1"		},
		{	2,   "2"		},
		{	3,   "3"		},
		{	4,   "4"		},
		{	5,   "5"		},
		{	6,   "6"		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_readback_value
{
	LABEL		[func_ao_readback_value];
	HELP		[func_ao_readback_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ;
}

VARIABLE func3_AO_3_readback_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_readback_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING	READ;
}

func3_AO_3_readback_status_limit            LIKE VARIABLE    func3_AO_3_readback_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_3_rcas_in_value
{
	LABEL		[func_rcas_in_value];
	HELP		[func_rcas_in_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_rcas_in_status_quality
{
	LABEL		[status_quality];
	HELP		[func_rcas_in_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_3
	}
	HANDLING	READ & WRITE;
}

func3_AO_3_rcas_in_status_limit            LIKE VARIABLE    func3_AO_3_rcas_in_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_3_rcas_in_status_quality)
    }
}

VARIABLE func3_AO_3_in_channel
{
	LABEL		[MC_channel];
	HELP		[func_channel_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(2)
	{
        DEFAULT_VALUE   3;
        {1,    "Mod_Out_1(TB)"              },
        {2,    "Mod_Out_2(TB)"              },
        {3,    "Mod_Out_3(TB)"              },
        {4,    "Mod_Out_4(TB)"              }
	}
	HANDLING	READ & WRITE;
}

func3_AO_3_out_channel							LIKE VARIABLE	func3_AO_3_in_channel
{
	REDEFINE LABEL [MC_channel];
}

VARIABLE func3_AO_3_fsafe_time
{
	LABEL		[func_ao_fsafe_time];
	HELP		[func_ao_fsafe_time_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_fsafe_type
{
	LABEL		[func_ao_fsafe_type];
	HELP		[func_ao_fsafe_type_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[func_ao_fsafe_type_FAIL_SAFE_VALUE]		},
		{	1,	[func_ao_fsafe_type_STORING_LAST_SETPOINT]	},
		{	2,	[func_ao_fsafe_type_FAIL_SAFE_POSITION]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_fsafe_value
{
	LABEL		"Fail Safe Value";
	HELP		[func_ao_fsafe_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_rcas_out_value
{
	LABEL		[func_rcas_out_value];
	HELP		[func_rcas_out_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
}

VARIABLE func3_AO_3_rcas_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_rcas_out_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_RCAS
	}
	HANDLING READ;
}

func3_AO_3_rcas_out_status_limit            LIKE VARIABLE    func3_AO_3_rcas_out_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_3_position_discrete_value
{
	LABEL		[func_ao_position_discrete_value];
	HELP		[func_ao_position_discrete_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0,	[func_ao_position_discrete_status_NOT_INIT]			},
		{	1,	[func_ao_position_discrete_status_CLOSED]			},
		{	2,	[func_ao_position_discrete_status_OPENED]			},
		{	3,	[func_ao_position_discrete_status_INTERMEDIATE]		}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_3_position_discrete_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_position_discrete_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING READ;
}

func3_AO_3_position_discrete_status_limit            LIKE VARIABLE    func3_AO_3_position_discrete_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_3_setpoint_deviation
{
	LABEL		[func_ao_setpoint_deviation];
	HELP		[func_ao_setpoint_deviation_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	CONSTANT_UNIT	[Percent];
	HANDLING	READ;
}

VARIABLE func3_AO_3_check_back
{
	LABEL		[func_check_back];
	HELP		[func_check_back_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (3)
	{
		{	0,					[dia_OK],				[dia_OK_help]				},
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]		},
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func3_AO_3_check_back_mask
{
	LABEL		[func_check_back_mask];
	HELP		[func_check_back_mask_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (3)
	{
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]		},
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_3_simulate_value
{
	LABEL		"Simulate Value";
	HELP		[func_ao_simulate_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_simulate_status_quality
{
	LABEL		[status_quality];
	HELP		[func_simulate_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
        STATUS_INPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_3
	}
	HANDLING READ & WRITE;
}

func3_AO_3_simulate_status_limit            LIKE VARIABLE    func3_AO_3_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_3_simulate_status_quality)
    }
}

VARIABLE func3_AO_3_simulation_enabled
{
	LABEL		[func_simulation_enabled];
	HELP		[func_simulation_enabled_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[disabled]		},
		{	1,	[enabled]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_increase_close
{
	LABEL		"Action"; /* [func_ao_increase_close]; */
	HELP		[func_ao_increase_close_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	"Opening" /* [func_ao_increase_close_RISING]	*/	},
		{	1,	"Closing" /* [func_ao_increase_close_FALLING] */	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_out_value
{
	LABEL		[func_out_value];
	HELP		[func_ao_out_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING
		IF ((func3_AO_3_actual_mode == BLOCK_MODE_MAN) || (func3_AO_3_actual_mode == BLOCK_MODE_LO))
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

VARIABLE func3_AO_3_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_out_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		IF ((func3_AO_3_actual_mode == BLOCK_MODE_MAN) || (func3_AO_3_actual_mode == BLOCK_MODE_LO))
		{
			STATUS_INPUT_NO_RCAS
		}
		ELSE {
			STATUS_OUTPUT_NO_RCAS
		}
	}
	POST_EDIT_ACTIONS
	{
		IF ((func3_AO_3_actual_mode == BLOCK_MODE_MAN) || (func3_AO_3_actual_mode == BLOCK_MODE_LO))
		{
			method_set_status_limit_func3_AO_3
		}
	}
	HANDLING
		IF ((func3_AO_3_actual_mode == BLOCK_MODE_MAN) || (func3_AO_3_actual_mode == BLOCK_MODE_LO))
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

func3_AO_3_out_status_limit            LIKE VARIABLE    func3_AO_3_out_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_3_out_upper_range_value
{
	LABEL		"Upper [EU(100%)]";
	HELP		[func_out_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_out_lower_range_value
{
	LABEL		"Lower [EU(0%)]";
	HELP		[func_out_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_3_out_unit
{
	LABEL		[func_out_scale_unit];
	HELP		[func_out_scale_unit_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1342;
		UNIT_LIST
	}
	HANDLING	READ & WRITE;
}

func3_AO_3_out_decimal_point						LIKE VARIABLE	func3_AO_3_pv_decimal_point
{
}

/***********************************************************************/
/*   AO-4		                                              */
/***********************************************************************/

BLOCK func3_AO_4
{
	TYPE	FUNCTION;
	NUMBER	8;
}

func3_AO_4_blk_reserve							LIKE VARIABLE	phys_blk_reserve
{
}

VARIABLE func3_AO_4_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[blk_block_object_FUNCTION]		}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_4_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[func_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	2,	[func_blk_parent_class_OUTPUT]	}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_4_blk_class
{
	LABEL		[blk_class];
	HELP		[func_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{	1,	[func_blk_class_AO]		}
	}
	HANDLING	READ;
}

func3_AO_4_blk_dd_reference						LIKE VARIABLE	phys_blk_dd_reference
{
}

func3_AO_4_blk_dd_rev							LIKE VARIABLE	phys_blk_dd_rev
{
}

func3_AO_4_blk_profile							LIKE VARIABLE	phys_blk_profile
{
}

func3_AO_4_blk_profile_rev						LIKE VARIABLE	phys_blk_profile_rev
{
}
											
func3_AO_4_blk_execution_time					LIKE VARIABLE	phys_blk_execution_time
{											
}											
											
func3_AO_4_blk_num_parameters					LIKE VARIABLE	phys_blk_num_parameters
{											
}											
											
func3_AO_4_blk_index_view_1						LIKE VARIABLE	phys_blk_index_view_1
{											
}

func3_AO_4_blk_num_view_lists					LIKE VARIABLE	phys_blk_num_view_lists
{											
}											
											
func3_AO_4_st_rev								LIKE VARIABLE	phys_st_rev
{
	REDEFINE LABEL  "AO_4 ST_REV";
}
											
func3_AO_4_tag_desc								LIKE VARIABLE	phys_tag_desc
{
	REDEFINE LABEL "AO-4 Tag";
    TYPE                ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}
											
func3_AO_4_strategy								LIKE VARIABLE	phys_strategy
{											
}											
											
func3_AO_4_alert_key								LIKE VARIABLE	phys_alert_key
{											
}

func3_AO_4_target_mode							LIKE VARIABLE	phys_target_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	BLOCK_MODE_AUTO;
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_4_actual_mode							LIKE VARIABLE	phys_actual_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_4_permitted_mode						LIKE VARIABLE	phys_permitted_mode
{
	REDEFINE TYPE		BIT_ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_4_normal_mode							LIKE VARIABLE	phys_normal_mode
{
	REDEFINE TYPE		ENUMERATED (1)
	{
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
}

func3_AO_4_current_state_alarm_sum				LIKE VARIABLE	phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_4_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_4_unreported_state_alarm_sum			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func3_AO_4_disabled_state_alarm_sum				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
        /*,
        {    0x8000,    [limit_state_ST_REV]    }*/
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func3_AO_4_batch_id
{
	LABEL		[func_batch_id];		
	HELP		[func_batch_id_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_batch_unit
{
	LABEL		[func_batch_unit];		
	HELP		[func_batch_unit_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_batch_operation
{
	LABEL		[func_batch_operation];		
	HELP		[func_batch_operation_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_batch_phase
{
	LABEL		[func_batch_phase];		
	HELP		[func_batch_phase_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    Function Block: Analog Output							           */
/*---------------------------------------------------------------------*/

VARIABLE func3_AO_4_setpoint_value
{
	LABEL		[func_ao_setpoint_value];
	HELP		[func_ao_setpoint_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	
		IF (func3_AO_4_target_mode == BLOCK_MODE_AUTO)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}	

}

VARIABLE func3_AO_4_setpoint_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_setpoint_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_4
	}
  	HANDLING	
		IF (func3_AO_4_target_mode == BLOCK_MODE_AUTO)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

func3_AO_4_setpoint_status_limit            LIKE VARIABLE    func3_AO_4_setpoint_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_4_setpoint_status_quality)
    }
}

VARIABLE func3_AO_4_pv_upper_range_value
{
	LABEL		"Upper [EU(100%)]";
	HELP		[func_pv_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_pv_lower_range_value
{
	LABEL		"Lower [EU(0%)]";
	HELP		[func_pv_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_pv_unit
{
	LABEL		[func_pv_scale_unit];
	HELP		[func_pv_scale_unit_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1342;
		UNIT_LIST
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_pv_decimal_point
{
	LABEL		[decimal_point];
	HELP		[decimal_point_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	2;
		{	0,   "0"		},
		{	1,   "1"		},
		{	2,   "2"		},
		{	3,   "3"		},
		{	4,   "4"		},
		{	5,   "5"		},
		{	6,   "6"		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_readback_value
{
	LABEL		[func_ao_readback_value];
	HELP		[func_ao_readback_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ;
}

VARIABLE func3_AO_4_readback_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_readback_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING	READ;
}

func3_AO_4_readback_status_limit            LIKE VARIABLE    func3_AO_4_readback_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_4_rcas_in_value
{
	LABEL		[func_rcas_in_value];
	HELP		[func_rcas_in_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_rcas_in_status_quality
{
	LABEL		[status_quality];
	HELP		[func_rcas_in_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_INPUT_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_4
	}
	HANDLING	READ & WRITE;
}

func3_AO_4_rcas_in_status_limit            LIKE VARIABLE    func3_AO_4_rcas_in_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_4_rcas_in_status_quality)
    }
}

VARIABLE func3_AO_4_in_channel
{
	LABEL		[MC_channel];
	HELP		[func_channel_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(2)
	{
        DEFAULT_VALUE   4;
        {1,    "Mod_Out_1(TB)"              },
        {2,    "Mod_Out_2(TB)"              },
        {3,    "Mod_Out_3(TB)"              },
        {4,    "Mod_Out_4(TB)"              }
	}
	HANDLING	READ & WRITE;
}

func3_AO_4_out_channel							LIKE VARIABLE	func3_AO_4_in_channel
{
	REDEFINE LABEL [MC_channel];
}

VARIABLE func3_AO_4_fsafe_time
{
	LABEL		[func_ao_fsafe_time];
	HELP		[func_ao_fsafe_time_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0;
	}
	CONSTANT_UNIT	[sec];
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_fsafe_type
{
	LABEL		[func_ao_fsafe_type];
	HELP		[func_ao_fsafe_type_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[func_ao_fsafe_type_FAIL_SAFE_VALUE]		},
		{	1,	[func_ao_fsafe_type_STORING_LAST_SETPOINT]	},
		{	2,	[func_ao_fsafe_type_FAIL_SAFE_POSITION]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_fsafe_value
{
	LABEL		"Fail Safe Value";
	HELP		[func_ao_fsafe_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_rcas_out_value
{
	LABEL		[func_rcas_out_value];
	HELP		[func_rcas_out_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	HANDLING	READ;
}

VARIABLE func3_AO_4_rcas_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_rcas_out_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_RCAS
	}
	HANDLING READ;
}

func3_AO_4_rcas_out_status_limit            LIKE VARIABLE    func3_AO_4_rcas_out_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_4_position_discrete_value
{
	LABEL		[func_ao_position_discrete_value];
	HELP		[func_ao_position_discrete_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		{	0,	[func_ao_position_discrete_status_NOT_INIT]			},
		{	1,	[func_ao_position_discrete_status_CLOSED]			},
		{	2,	[func_ao_position_discrete_status_OPENED]			},
		{	3,	[func_ao_position_discrete_status_INTERMEDIATE]		}
	}
	HANDLING	READ;
}

VARIABLE func3_AO_4_position_discrete_status_quality
{
	LABEL		[status_quality];
	HELP		[func_ao_position_discrete_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_OUTPUT_NO_RCAS
	}
	HANDLING READ;
}

func3_AO_4_position_discrete_status_limit            LIKE VARIABLE    func3_AO_4_position_discrete_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_4_setpoint_deviation
{
	LABEL		[func_ao_setpoint_deviation];
	HELP		[func_ao_setpoint_deviation_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT;
	CONSTANT_UNIT	[Percent];
	HANDLING	READ;
}

VARIABLE func3_AO_4_check_back
{
	LABEL		[func_check_back];
	HELP		[func_check_back_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (3)
	{
		{	0,					[dia_OK],				[dia_OK_help]				},
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]		},
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func3_AO_4_check_back_mask
{
	LABEL		[func_check_back_mask];
	HELP		[func_check_back_mask_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (3)
	{
		{	CB_FAIL_SAFE,		[cb_FAIL_SAFE],			[cb_FAIL_SAFE_help]			},
		{	CB_REQ_LOC_OP,		[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]		},
		{	CB_LOCAL_OP,		[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
		{	CB_OVERRIDE,		[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
		{	CB_DISC_DIR,		[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
		{	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
		{	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
		{	CB_TRAV_TIME,		[cb_TRAV_TIME],			[cb_TRAV_TIME_help]			},
		{	CB_ACT_OPEN,		[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
		{	CB_ACT_CLOSE,		[cb_ACT_CLOSE],			[cb_ACT_CLOSE_help]			},
		{	CB_UPDATE_EVT,		[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]		},
		{	CB_SIMULATE,		[cb_SIMULATE],			[cb_SIMULATE_help]			},
		{	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
		{	CB_CONTR_ERR,		[cb_CONTR_ERR],			[cb_CONTR_ERR_help]			},
		{	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
		{	CB_SELFTEST,		[cb_SELFTEST],			[cb_SELFTEST_help]			},
		{	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
	}
	HANDLING	READ;
    STYLE      "MULTILINE 10 8" ;
}

VARIABLE func3_AO_4_simulate_value
{
	LABEL		"Simulate Value";
	HELP		[func_ao_simulate_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_simulate_status_quality
{
	LABEL		[status_quality];
	HELP		[func_simulate_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
        STATUS_INPUT_NO_RCAS
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_AO_4
	}
	HANDLING READ & WRITE;
}

func3_AO_4_simulate_status_limit            LIKE VARIABLE    func3_AO_4_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func3_AO_4_simulate_status_quality)
    }
}

VARIABLE func3_AO_4_simulation_enabled
{
	LABEL		[func_simulation_enabled];
	HELP		[func_simulation_enabled_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[disabled]		},
		{	1,	[enabled]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_increase_close
{
	LABEL		"Action"; /* [func_ao_increase_close]; */
	HELP		[func_ao_increase_close_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	"Opening" /* [func_ao_increase_close_RISING]	*/	},
		{	1,	"Closing" /* [func_ao_increase_close_FALLING] */	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_out_value
{
	LABEL		[func_out_value];
	HELP		[func_ao_out_value_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING
		IF ((func3_AO_4_actual_mode == BLOCK_MODE_MAN) || (func3_AO_4_actual_mode == BLOCK_MODE_LO))
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

VARIABLE func3_AO_4_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_out_status_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		IF ((func3_AO_4_actual_mode == BLOCK_MODE_MAN) || (func3_AO_4_actual_mode == BLOCK_MODE_LO))
		{
			STATUS_INPUT_NO_RCAS
		}
		ELSE {
			STATUS_OUTPUT_NO_RCAS
		}
	}
	POST_EDIT_ACTIONS
	{
		IF ((func3_AO_4_actual_mode == BLOCK_MODE_MAN) || (func3_AO_4_actual_mode == BLOCK_MODE_LO))
		{
			method_set_status_limit_func3_AO_4
		}
	}
	HANDLING
		IF ((func3_AO_4_actual_mode == BLOCK_MODE_MAN) || (func3_AO_4_actual_mode == BLOCK_MODE_LO))
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

func3_AO_4_out_status_limit            LIKE VARIABLE    func3_AO_4_out_status_quality
{
    REDEFINE LABEL       [status_limit];        
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func3_AO_4_out_upper_range_value
{
	LABEL		"Upper [EU(100%)]";
	HELP		[func_out_scale_upper_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	100.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_out_lower_range_value
{
	LABEL		"Lower [EU(0%)]";
	HELP		[func_out_scale_lower_value_help];
	CLASS		CONTAINED;
	TYPE		FLOAT
	{
		DEFAULT_VALUE	0.0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_AO_4_out_unit
{
	LABEL		[func_out_scale_unit];
	HELP		[func_out_scale_unit_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE 1342;
		UNIT_LIST
	}
	HANDLING	READ & WRITE;
}

func3_AO_4_out_decimal_point						LIKE VARIABLE	func3_AO_4_pv_decimal_point
{
}

UNIT AO_1_PV_SCALE_UNIT
{
	func3_AO_1_pv_unit:

	func3_AO_1_pv_upper_range_value,
	func3_AO_1_pv_lower_range_value,
	func3_AO_1_readback_value,
	func3_AO_1_setpoint_value,
	func3_AO_1_rcas_in_value,
	func3_AO_1_rcas_out_value,
	func3_AO_1_fsafe_value
}

UNIT AO_1_OUT_SCALE_UNIT
{
	func3_AO_1_out_unit:

	func3_AO_1_out_value,
	func3_AO_1_out_upper_range_value,
	func3_AO_1_out_lower_range_value,
	func3_AO_1_simulate_value
}

UNIT AO_2_PV_SCALE_UNIT
{
	func3_AO_2_pv_unit:

	func3_AO_2_pv_upper_range_value,
	func3_AO_2_pv_lower_range_value,
	func3_AO_2_readback_value,
	func3_AO_2_setpoint_value,
	func3_AO_2_rcas_in_value,
	func3_AO_2_rcas_out_value,
	func3_AO_2_fsafe_value
}

UNIT AO_2_OUT_SCALE_UNIT
{
	func3_AO_2_out_unit:

	func3_AO_2_out_value,
	func3_AO_2_out_upper_range_value,
	func3_AO_2_out_lower_range_value,
	func3_AO_2_simulate_value
}

UNIT AO_3_PV_SCALE_UNIT
{
	func3_AO_3_pv_unit:

	func3_AO_3_pv_upper_range_value,
	func3_AO_3_pv_lower_range_value,
	func3_AO_3_readback_value,
	func3_AO_3_setpoint_value,
	func3_AO_3_rcas_in_value,
	func3_AO_3_rcas_out_value,
	func3_AO_3_fsafe_value
}

UNIT AO_3_OUT_SCALE_UNIT
{
	func3_AO_3_out_unit:

	func3_AO_3_out_value,
	func3_AO_3_out_upper_range_value,
	func3_AO_3_out_lower_range_value,
	func3_AO_3_simulate_value
}

UNIT AO_4_PV_SCALE_UNIT
{
	func3_AO_4_pv_unit:

	func3_AO_4_pv_upper_range_value,
	func3_AO_4_pv_lower_range_value,
	func3_AO_4_readback_value,
	func3_AO_4_setpoint_value,
	func3_AO_4_rcas_in_value,
	func3_AO_4_rcas_out_value,
	func3_AO_4_fsafe_value
}

UNIT AO_4_OUT_SCALE_UNIT
{
	func3_AO_4_out_unit:

	func3_AO_4_out_value,
	func3_AO_4_out_upper_range_value,
	func3_AO_4_out_lower_range_value,
	func3_AO_4_simulate_value
}


/*---------------------------------------------------------------------*/
/*    Function Block												   */
/*---------------------------------------------------------------------*/

COMMAND read_func3_AO_1_blk
{
	BLOCK func3_AO_1;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_blk_reserve, func3_AO_1_blk_object, func3_AO_1_blk_parent_class, func3_AO_1_blk_class,
			func3_AO_1_blk_dd_reference, func3_AO_1_blk_dd_rev, func3_AO_1_blk_profile, func3_AO_1_blk_profile_rev,
			func3_AO_1_blk_execution_time, func3_AO_1_blk_num_parameters, func3_AO_1_blk_index_view_1,
			func3_AO_1_blk_num_view_lists
		}
	}
}

COMMAND read_func3_AO_1_st_rev
{
	BLOCK func3_AO_1;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_st_rev   
		}
	}
}

COMMAND read_func3_AO_1_tag_desc
{
	BLOCK func3_AO_1;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_tag_desc
		}
	}
}

COMMAND write_func3_AO_1_tag_desc
{
	BLOCK func3_AO_1;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_strategy
{
	BLOCK func3_AO_1;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_strategy
		}
	}
}

COMMAND write_func3_AO_1_strategy
{
	BLOCK func3_AO_1;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_alert_key
{
	BLOCK func3_AO_1;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_alert_key
		}
	}
}

COMMAND write_func3_AO_1_alert_key
{
	BLOCK func3_AO_1;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_target_mode
{
	BLOCK func3_AO_1;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_target_mode
		}
	}
}

COMMAND write_func3_AO_1_target_mode
{
	BLOCK func3_AO_1;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_mode
{
	BLOCK func3_AO_1;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 func3_AO_1_actual_mode, func3_AO_1_permitted_mode, func3_AO_1_normal_mode
		}
	}
}

COMMAND read_func3_AO_1_alarm
{
	BLOCK func3_AO_1;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_current_state_alarm_sum, func3_AO_1_unacknowledged_state_alarm_sum,
			func3_AO_1_unreported_state_alarm_sum, func3_AO_1_disabled_state_alarm_sum
		}
	}
}

COMMAND read_func3_AO_1_batch_information
{
	BLOCK func3_AO_1;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_batch_id, func3_AO_1_batch_unit, func3_AO_1_batch_operation, func3_AO_1_batch_phase
		}
	}
}

COMMAND write_func3_AO_1_batch_information
{
	BLOCK func3_AO_1;
	INDEX 8;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_batch_id, func3_AO_1_batch_unit, func3_AO_1_batch_operation, func3_AO_1_batch_phase
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_setpoint 
{
	BLOCK func3_AO_1;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_setpoint_value,
			func3_AO_1_setpoint_status_quality <0xFC>,
            func3_AO_1_setpoint_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_1_setpoint 
{
	BLOCK func3_AO_1;
	INDEX 9;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_setpoint_value,
			func3_AO_1_setpoint_status_quality <0xFC>,
            func3_AO_1_setpoint_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_pv 
{
	BLOCK func3_AO_1;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_pv_upper_range_value, func3_AO_1_pv_lower_range_value, 
			func3_AO_1_pv_unit, func3_AO_1_pv_decimal_point
		}
	}
}

COMMAND write_func3_AO_1_pv 
{
	BLOCK func3_AO_1;
	INDEX 11;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_pv_upper_range_value, func3_AO_1_pv_lower_range_value, 
			func3_AO_1_pv_unit, func3_AO_1_pv_decimal_point
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_readback 
{
	BLOCK func3_AO_1;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
            func3_AO_1_readback_value,
            func3_AO_1_readback_status_quality <0xFC>,
            func3_AO_1_readback_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_1_rcas_in
{
	BLOCK func3_AO_1;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_rcas_in_value,
            func3_AO_1_rcas_in_status_quality <0xFC>,
            func3_AO_1_rcas_in_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_1_rcas_in
{
	BLOCK func3_AO_1;
	INDEX 14;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_rcas_in_value,
            func3_AO_1_rcas_in_status_quality <0xFC>,
            func3_AO_1_rcas_in_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_in_channel
{
	BLOCK func3_AO_1;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_in_channel
		}
	}
}

COMMAND write_func3_AO_1_in_channel
{
	BLOCK func3_AO_1;
	INDEX 21;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_in_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_out_channel 
{
	BLOCK func3_AO_1;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_out_channel
		}
	}
}

COMMAND write_func3_AO_1_out_channel 
{
	BLOCK func3_AO_1;
	INDEX 22;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_out_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_fsafe_time
{
	BLOCK func3_AO_1;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_fsafe_time
		}
	}
}

COMMAND write_func3_AO_1_fsafe_time
{
	BLOCK func3_AO_1;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_fsafe_time
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_fsafe_type
{
	BLOCK func3_AO_1;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_fsafe_type
		}
	}
}

COMMAND write_func3_AO_1_fsafe_type
{
	BLOCK func3_AO_1;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_fsafe_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_fsafe_value
{
	BLOCK func3_AO_1;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_fsafe_value
		}
	}
}

COMMAND write_func3_AO_1_fsafe_value
{
	BLOCK func3_AO_1;
	INDEX 25;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_fsafe_value
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_rcas_out
{
	BLOCK func3_AO_1;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_rcas_out_value,
            func3_AO_1_rcas_out_status_quality <0xFC>,
            func3_AO_1_rcas_out_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_1_current_position 
{
	BLOCK func3_AO_1;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_position_discrete_value,
            func3_AO_1_position_discrete_status_quality <0xFC>,
            func3_AO_1_position_discrete_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_1_setpoint_deviation
{
	BLOCK func3_AO_1;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_setpoint_deviation
		}
	}
}

COMMAND read_func3_AO_1_check_back 
{
	BLOCK func3_AO_1;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_check_back
		}
	}
}

COMMAND read_func3_AO_1_check_back_mask 
{
	BLOCK func3_AO_1;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_check_back_mask
		}
	}
}

COMMAND read_func3_AO_1_simulate 
{
	BLOCK func3_AO_1;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
            func3_AO_1_simulate_status_quality <0xFC>,
            func3_AO_1_simulate_status_limit   <0x03>,
			func3_AO_1_simulate_value, 
			func3_AO_1_simulation_enabled
		}
	}
}

COMMAND write_func3_AO_1_simulate 
{
	BLOCK func3_AO_1;
	INDEX 35;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
            func3_AO_1_simulate_status_quality <0xFC>,
            func3_AO_1_simulate_status_limit   <0x03>,
			func3_AO_1_simulate_value,
			func3_AO_1_simulation_enabled
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_increase_close 
{
	BLOCK func3_AO_1;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_increase_close
		}
	}
}

COMMAND write_func3_AO_1_increase_close 
{
	BLOCK func3_AO_1;
	INDEX 36;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_increase_close
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_out
{
	BLOCK func3_AO_1;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_out_value,
            func3_AO_1_out_status_quality <0xFC>,
            func3_AO_1_out_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_1_out
{
	BLOCK func3_AO_1;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_out_value,
            func3_AO_1_out_status_quality <0xFC>,
            func3_AO_1_out_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_1_out_scale 
{
	BLOCK func3_AO_1;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_1_out_upper_range_value, func3_AO_1_out_lower_range_value, 
			func3_AO_1_out_unit, func3_AO_1_out_decimal_point 
		}
	}
}

COMMAND write_func3_AO_1_out_scale
{
	BLOCK func3_AO_1;
	INDEX 38;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_1_out_upper_range_value, func3_AO_1_out_lower_range_value, 
			func3_AO_1_out_unit, func3_AO_1_out_decimal_point
		}
		REPLY
		{
		}
	}
}


/*---------------------------------------------------------------------*/
/*    Function Block												   */
/*---------------------------------------------------------------------*/

COMMAND read_func3_AO_2_blk
{
	BLOCK func3_AO_2;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_blk_reserve, func3_AO_2_blk_object, func3_AO_2_blk_parent_class, func3_AO_2_blk_class,
			func3_AO_2_blk_dd_reference, func3_AO_2_blk_dd_rev, func3_AO_2_blk_profile, func3_AO_2_blk_profile_rev,
			func3_AO_2_blk_execution_time, func3_AO_2_blk_num_parameters, func3_AO_2_blk_index_view_1,
			func3_AO_2_blk_num_view_lists
		}
	}
}

COMMAND read_func3_AO_2_st_rev
{
	BLOCK func3_AO_2;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_st_rev   
		}
	}
}

COMMAND read_func3_AO_2_tag_desc
{
	BLOCK func3_AO_2;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_tag_desc
		}
	}
}

COMMAND write_func3_AO_2_tag_desc
{
	BLOCK func3_AO_2;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_strategy
{
	BLOCK func3_AO_2;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_strategy
		}
	}
}

COMMAND write_func3_AO_2_strategy
{
	BLOCK func3_AO_2;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_alert_key
{
	BLOCK func3_AO_2;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_alert_key
		}
	}
}

COMMAND write_func3_AO_2_alert_key
{
	BLOCK func3_AO_2;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_target_mode
{
	BLOCK func3_AO_2;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_target_mode
		}
	}
}

COMMAND write_func3_AO_2_target_mode
{
	BLOCK func3_AO_2;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_mode
{
	BLOCK func3_AO_2;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 func3_AO_2_actual_mode, func3_AO_2_permitted_mode, func3_AO_2_normal_mode
		}
	}
}

COMMAND read_func3_AO_2_alarm
{
	BLOCK func3_AO_2;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_current_state_alarm_sum, func3_AO_2_unacknowledged_state_alarm_sum,
			func3_AO_2_unreported_state_alarm_sum, func3_AO_2_disabled_state_alarm_sum
		}
	}
}

COMMAND read_func3_AO_2_batch_information
{
	BLOCK func3_AO_2;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_batch_id, func3_AO_2_batch_unit, func3_AO_2_batch_operation, func3_AO_2_batch_phase
		}
	}
}

COMMAND write_func3_AO_2_batch_information
{
	BLOCK func3_AO_2;
	INDEX 8;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_batch_id, func3_AO_2_batch_unit, func3_AO_2_batch_operation, func3_AO_2_batch_phase
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_setpoint 
{
	BLOCK func3_AO_2;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_setpoint_value,
			func3_AO_2_setpoint_status_quality <0xFC>,
            func3_AO_2_setpoint_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_2_setpoint 
{
	BLOCK func3_AO_2;
	INDEX 9;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_setpoint_value,
			func3_AO_2_setpoint_status_quality <0xFC>,
            func3_AO_2_setpoint_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_pv 
{
	BLOCK func3_AO_2;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_pv_upper_range_value, func3_AO_2_pv_lower_range_value, 
			func3_AO_2_pv_unit, func3_AO_2_pv_decimal_point
		}
	}
}

COMMAND write_func3_AO_2_pv 
{
	BLOCK func3_AO_2;
	INDEX 11;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_pv_upper_range_value, func3_AO_2_pv_lower_range_value, 
			func3_AO_2_pv_unit, func3_AO_2_pv_decimal_point
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_readback 
{
	BLOCK func3_AO_2;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_readback_value,
            func3_AO_2_readback_status_quality <0xFC>,
            func3_AO_2_readback_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_2_rcas_in
{
	BLOCK func3_AO_2;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_rcas_in_value,
            func3_AO_2_rcas_in_status_quality <0xFC>,
            func3_AO_2_rcas_in_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_2_rcas_in
{
	BLOCK func3_AO_2;
	INDEX 14;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_rcas_in_value,
            func3_AO_2_rcas_in_status_quality <0xFC>,
            func3_AO_2_rcas_in_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_in_channel 
{
	BLOCK func3_AO_2;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_in_channel
		}
	}
}

COMMAND write_func3_AO_2_in_channel 
{
	BLOCK func3_AO_2;
	INDEX 21;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_in_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_out_channel 
{
	BLOCK func3_AO_2;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_out_channel
		}
	}
}

COMMAND write_func3_AO_2_out_channel 
{
	BLOCK func3_AO_2;
	INDEX 22;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_out_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_fsafe_time 
{
	BLOCK func3_AO_2;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_fsafe_time
		}
	}
}

COMMAND write_func3_AO_2_fsafe_time 
{
	BLOCK func3_AO_2;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_fsafe_time
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_fsafe_type
{
	BLOCK func3_AO_2;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_fsafe_type
		}
	}
}

COMMAND write_func3_AO_2_fsafe_type
{
	BLOCK func3_AO_2;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_fsafe_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_fsafe_value
{
	BLOCK func3_AO_2;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_fsafe_value
		}
	}
}

COMMAND write_func3_AO_2_fsafe_value
{
	BLOCK func3_AO_2;
	INDEX 25;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_fsafe_value
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_rcas_out
{
	BLOCK func3_AO_2;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_rcas_out_value,
            func3_AO_2_rcas_out_status_quality <0xFC>,
            func3_AO_2_rcas_out_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_2_current_position 
{
	BLOCK func3_AO_2;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_position_discrete_value,
            func3_AO_2_position_discrete_status_quality <0xFC>,
            func3_AO_2_position_discrete_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_2_setpoint_deviation 
{
	BLOCK func3_AO_2;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_setpoint_deviation
		}
	}
}

COMMAND read_func3_AO_2_check_back 
{
	BLOCK func3_AO_2;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_check_back
		}
	}
}

COMMAND read_func3_AO_2_check_back_mask 
{
	BLOCK func3_AO_2;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_check_back_mask
		}
	}
}

COMMAND read_func3_AO_2_simulate 
{
	BLOCK func3_AO_2;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
            func3_AO_2_simulate_status_quality <0xFC>,
            func3_AO_2_simulate_status_limit   <0x03>,
			func3_AO_2_simulate_value, 
			func3_AO_2_simulation_enabled
		}
	}
}

COMMAND write_func3_AO_2_simulate 
{
	BLOCK func3_AO_2;
	INDEX 35;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
            func3_AO_2_simulate_status_quality <0xFC>,
            func3_AO_2_simulate_status_limit   <0x03>,
			func3_AO_2_simulate_value, 
			func3_AO_2_simulation_enabled
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_increase_close 
{
	BLOCK func3_AO_2;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_increase_close
		}
	}
}

COMMAND write_func3_AO_2_increase_close 
{
	BLOCK func3_AO_2;
	INDEX 36;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_increase_close
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_out 
{
	BLOCK func3_AO_2;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_out_value,
            func3_AO_2_out_status_quality <0xFC>,
            func3_AO_2_out_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_2_out 
{
	BLOCK func3_AO_2;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_out_value,
            func3_AO_2_out_status_quality <0xFC>,
            func3_AO_2_out_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_2_out_scale 
{
	BLOCK func3_AO_2;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_2_out_upper_range_value, func3_AO_2_out_lower_range_value, 
			func3_AO_2_out_unit, func3_AO_2_out_decimal_point 
		}
	}
}

COMMAND write_func3_AO_2_out_scale
{
	BLOCK func3_AO_2;
	INDEX 38;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_2_out_upper_range_value, func3_AO_2_out_lower_range_value, 
			func3_AO_2_out_unit, func3_AO_2_out_decimal_point
		}
		REPLY
		{
		}
	}
}



/*---------------------------------------------------------------------*/
/*    Function Block												   */
/*---------------------------------------------------------------------*/

COMMAND read_func3_AO_3_blk
{
	BLOCK func3_AO_3;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_blk_reserve, func3_AO_3_blk_object, func3_AO_3_blk_parent_class, func3_AO_3_blk_class,
			func3_AO_3_blk_dd_reference, func3_AO_3_blk_dd_rev, func3_AO_3_blk_profile, func3_AO_3_blk_profile_rev,
			func3_AO_3_blk_execution_time, func3_AO_3_blk_num_parameters, func3_AO_3_blk_index_view_1,
			func3_AO_3_blk_num_view_lists
		}
	}
}

COMMAND read_func3_AO_3_st_rev
{
	BLOCK func3_AO_3;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_st_rev   
		}
	}
}

COMMAND read_func3_AO_3_tag_desc
{
	BLOCK func3_AO_3;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_tag_desc
		}
	}
}

COMMAND write_func3_AO_3_tag_desc
{
	BLOCK func3_AO_3;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_strategy
{
	BLOCK func3_AO_3;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_strategy
		}
	}
}

COMMAND write_func3_AO_3_strategy
{
	BLOCK func3_AO_3;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_alert_key
{
	BLOCK func3_AO_3;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_alert_key
		}
	}
}

COMMAND write_func3_AO_3_alert_key
{
	BLOCK func3_AO_3;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_target_mode
{
	BLOCK func3_AO_3;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_target_mode
		}
	}
}

COMMAND write_func3_AO_3_target_mode
{
	BLOCK func3_AO_3;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_mode
{
	BLOCK func3_AO_3;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 func3_AO_3_actual_mode, func3_AO_3_permitted_mode, func3_AO_3_normal_mode
		}
	}
}

COMMAND read_func3_AO_3_alarm
{
	BLOCK func3_AO_3;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_current_state_alarm_sum, func3_AO_3_unacknowledged_state_alarm_sum,
			func3_AO_3_unreported_state_alarm_sum, func3_AO_3_disabled_state_alarm_sum
		}
	}
}

COMMAND read_func3_AO_3_batch_information
{
	BLOCK func3_AO_3;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_batch_id, func3_AO_3_batch_unit, func3_AO_3_batch_operation, func3_AO_3_batch_phase
		}
	}
}

COMMAND write_func3_AO_3_batch_information
{
	BLOCK func3_AO_3;
	INDEX 8;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_batch_id, func3_AO_3_batch_unit, func3_AO_3_batch_operation, func3_AO_3_batch_phase
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_setpoint 
{
	BLOCK func3_AO_3;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_setpoint_value,
            func3_AO_3_setpoint_status_quality <0xFC>,
            func3_AO_3_setpoint_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_3_setpoint 
{
	BLOCK func3_AO_3;
	INDEX 9;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_setpoint_value,
            func3_AO_3_setpoint_status_quality <0xFC>,
            func3_AO_3_setpoint_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_pv 
{
	BLOCK func3_AO_3;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_pv_upper_range_value, func3_AO_3_pv_lower_range_value, 
			func3_AO_3_pv_unit, func3_AO_3_pv_decimal_point
		}
	}
}

COMMAND write_func3_AO_3_pv 
{
	BLOCK func3_AO_3;
	INDEX 11;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_pv_upper_range_value, func3_AO_3_pv_lower_range_value, 
			func3_AO_3_pv_unit, func3_AO_3_pv_decimal_point
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_readback 
{
	BLOCK func3_AO_3;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_readback_value,
            func3_AO_3_readback_status_quality <0xFC>,
            func3_AO_3_readback_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_3_rcas_in
{
	BLOCK func3_AO_3;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_rcas_in_value,
            func3_AO_3_rcas_in_status_quality <0xFC>,
            func3_AO_3_rcas_in_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_3_rcas_in
{
	BLOCK func3_AO_3;
	INDEX 14;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_rcas_in_value,
            func3_AO_3_rcas_in_status_quality <0xFC>,
            func3_AO_3_rcas_in_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_in_channel 
{
	BLOCK func3_AO_3;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_in_channel
		}
	}
}

COMMAND write_func3_AO_3_in_channel 
{
	BLOCK func3_AO_3;
	INDEX 21;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_in_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_out_channel 
{
	BLOCK func3_AO_3;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_out_channel
		}
	}
}

COMMAND write_func3_AO_3_out_channel 
{
	BLOCK func3_AO_3;
	INDEX 22;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_out_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_fsafe_time 
{
	BLOCK func3_AO_3;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_fsafe_time
		}
	}
}

COMMAND write_func3_AO_3_fsafe_time
{
	BLOCK func3_AO_3;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_fsafe_time
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_fsafe_type
{
	BLOCK func3_AO_3;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_fsafe_type
		}
	}
}

COMMAND write_func3_AO_3_fsafe_type
{
	BLOCK func3_AO_3;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_fsafe_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_fsafe_value
{
	BLOCK func3_AO_3;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_fsafe_value
		}
	}
}

COMMAND write_func3_AO_3_fsafe_value
{
	BLOCK func3_AO_3;
	INDEX 25;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_fsafe_value
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_rcas_out
{
	BLOCK func3_AO_3;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_rcas_out_value,
            func3_AO_3_rcas_out_status_quality <0xFC>,
            func3_AO_3_rcas_out_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_3_current_position
{
	BLOCK func3_AO_3;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_position_discrete_value,
            func3_AO_3_position_discrete_status_quality <0xFC>,
            func3_AO_3_position_discrete_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_3_setpoint_deviation 
{
	BLOCK func3_AO_3;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_setpoint_deviation
		}
	}
}

COMMAND read_func3_AO_3_check_back 
{
	BLOCK func3_AO_3;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_check_back
		}
	}
}

COMMAND read_func3_AO_3_check_back_mask
{
	BLOCK func3_AO_3;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_check_back_mask
		}
	}
}

COMMAND read_func3_AO_3_simulate 
{
	BLOCK func3_AO_3;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
            func3_AO_3_simulate_status_quality <0xFC>,
            func3_AO_3_simulate_status_limit   <0x03>,
			func3_AO_3_simulate_value,
			func3_AO_3_simulation_enabled
		}
	}
}

COMMAND write_func3_AO_3_simulate 
{
	BLOCK func3_AO_3;
	INDEX 35;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
            func3_AO_3_simulate_status_quality <0xFC>,
            func3_AO_3_simulate_status_limit   <0x03>,
			func3_AO_3_simulate_value, 
			func3_AO_3_simulation_enabled
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_increase_close 
{
	BLOCK func3_AO_3;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_increase_close
		}
	}
}

COMMAND write_func3_AO_3_increase_close 
{
	BLOCK func3_AO_3;
	INDEX 36;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_increase_close
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_out 
{
	BLOCK func3_AO_3;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_out_value,
            func3_AO_3_out_status_quality <0xFC>,
            func3_AO_3_out_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_3_out 
{
	BLOCK func3_AO_3;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_out_value,
            func3_AO_3_out_status_quality <0xFC>,
            func3_AO_3_out_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_3_out_scale 
{
	BLOCK func3_AO_3;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_3_out_upper_range_value, func3_AO_3_out_lower_range_value,
			func3_AO_3_out_unit, func3_AO_3_out_decimal_point
		}
	}
}

COMMAND write_func3_AO_3_out_scale
{
	BLOCK func3_AO_3;
	INDEX 38;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_3_out_upper_range_value, func3_AO_3_out_lower_range_value,
			func3_AO_3_out_unit, func3_AO_3_out_decimal_point
		}
		REPLY
		{
		}
	}
}

/*---------------------------------------------------------------------*/
/*    Function Block												   */
/*---------------------------------------------------------------------*/

COMMAND read_func3_AO_4_blk
{
	BLOCK func3_AO_4;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_blk_reserve, func3_AO_4_blk_object, func3_AO_4_blk_parent_class, func3_AO_4_blk_class,
			func3_AO_4_blk_dd_reference, func3_AO_4_blk_dd_rev, func3_AO_4_blk_profile, func3_AO_4_blk_profile_rev,
			func3_AO_4_blk_execution_time, func3_AO_4_blk_num_parameters, func3_AO_4_blk_index_view_1,
			func3_AO_4_blk_num_view_lists
		}
	}
}

COMMAND read_func3_AO_4_st_rev
{
	BLOCK func3_AO_4;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_st_rev   
		}
	}
}

COMMAND read_func3_AO_4_tag_desc
{
	BLOCK func3_AO_4;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_tag_desc
		}
	}
}

COMMAND write_func3_AO_4_tag_desc
{
	BLOCK func3_AO_4;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_strategy
{
	BLOCK func3_AO_4;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_strategy
		}
	}
}

COMMAND write_func3_AO_4_strategy
{
	BLOCK func3_AO_4;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_alert_key
{
	BLOCK func3_AO_4;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_alert_key
		}
	}
}

COMMAND write_func3_AO_4_alert_key
{
	BLOCK func3_AO_4;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_target_mode
{
	BLOCK func3_AO_4;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_target_mode
		}
	}
}

COMMAND write_func3_AO_4_target_mode
{
	BLOCK func3_AO_4;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_mode
{
	BLOCK func3_AO_4;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 func3_AO_4_actual_mode, func3_AO_4_permitted_mode, func3_AO_4_normal_mode
		}
	}
}

COMMAND read_func3_AO_4_alarm
{
	BLOCK func3_AO_4;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_current_state_alarm_sum, func3_AO_4_unacknowledged_state_alarm_sum,
			func3_AO_4_unreported_state_alarm_sum, func3_AO_4_disabled_state_alarm_sum
		}
	}
}

COMMAND read_func3_AO_4_batch_information
{
	BLOCK func3_AO_4;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_batch_id, func3_AO_4_batch_unit, func3_AO_4_batch_operation, func3_AO_4_batch_phase
		}
	}
}

COMMAND write_func3_AO_4_batch_information
{
	BLOCK func3_AO_4;
	INDEX 8;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_batch_id, func3_AO_4_batch_unit, func3_AO_4_batch_operation, func3_AO_4_batch_phase
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_setpoint 
{
	BLOCK func3_AO_4;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_setpoint_value,
            func3_AO_4_setpoint_status_quality <0xFC>,
            func3_AO_4_setpoint_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_4_setpoint 
{
	BLOCK func3_AO_4;
	INDEX 9;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_setpoint_value,
            func3_AO_4_setpoint_status_quality <0xFC>,
            func3_AO_4_setpoint_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_pv 
{
	BLOCK func3_AO_4;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_pv_upper_range_value, func3_AO_4_pv_lower_range_value, 
			func3_AO_4_pv_unit, func3_AO_4_pv_decimal_point
		}
	}
}

COMMAND write_func3_AO_4_pv 
{
	BLOCK func3_AO_4;
	INDEX 11;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_pv_upper_range_value, func3_AO_4_pv_lower_range_value, 
			func3_AO_4_pv_unit, func3_AO_4_pv_decimal_point
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_readback 
{
	BLOCK func3_AO_4;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_readback_value,
            func3_AO_4_readback_status_quality <0xFC>,
            func3_AO_4_readback_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_4_rcas_in
{
	BLOCK func3_AO_4;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_rcas_in_value,
            func3_AO_4_rcas_in_status_quality <0xFC>,
            func3_AO_4_rcas_in_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_4_rcas_in
{
	BLOCK func3_AO_4;
	INDEX 14;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_rcas_in_value,
            func3_AO_4_rcas_in_status_quality <0xFC>,
            func3_AO_4_rcas_in_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_in_channel 
{
	BLOCK func3_AO_4;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_in_channel
		}
	}
}

COMMAND write_func3_AO_4_in_channel 
{
	BLOCK func3_AO_4;
	INDEX 21;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_in_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_out_channel 
{
	BLOCK func3_AO_4;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_out_channel
		}
	}
}

COMMAND write_func3_AO_4_out_channel 
{
	BLOCK func3_AO_4;
	INDEX 22;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_out_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_fsafe_time 
{
	BLOCK func3_AO_4;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_fsafe_time
		}
	}
}

COMMAND write_func3_AO_4_fsafe_time
{
	BLOCK func3_AO_4;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_fsafe_time
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_fsafe_type
{
	BLOCK func3_AO_4;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_fsafe_type
		}
	}
}

COMMAND write_func3_AO_4_fsafe_type
{
	BLOCK func3_AO_4;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_fsafe_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_fsafe_value
{
	BLOCK func3_AO_4;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_fsafe_value
		}
	}
}

COMMAND write_func3_AO_4_fsafe_value
{
	BLOCK func3_AO_4;
	INDEX 25;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_fsafe_value
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_rcas_out
{
	BLOCK func3_AO_4;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_rcas_out_value,
            func3_AO_4_rcas_out_status_quality <0xFC>,
            func3_AO_4_rcas_out_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_4_current_position
{
	BLOCK func3_AO_4;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_position_discrete_value,
            func3_AO_4_position_discrete_status_quality <0xFC>,
            func3_AO_4_position_discrete_status_limit   <0x03>
		}
	}
}

COMMAND read_func3_AO_4_setpoint_deviation 
{
	BLOCK func3_AO_4;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_setpoint_deviation
		}
	}
}

COMMAND read_func3_AO_4_check_back 
{
	BLOCK func3_AO_4;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_check_back
		}
	}
}

COMMAND read_func3_AO_4_check_back_mask
{
	BLOCK func3_AO_4;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_check_back_mask
		}
	}
}

COMMAND read_func3_AO_4_simulate 
{
	BLOCK func3_AO_4;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
            func3_AO_4_simulate_status_quality <0xFC>,
            func3_AO_4_simulate_status_limit   <0x03>,
			func3_AO_4_simulate_value,
			func3_AO_4_simulation_enabled
		}
	}
}

COMMAND write_func3_AO_4_simulate 
{
	BLOCK func3_AO_4;
	INDEX 35;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
            func3_AO_4_simulate_status_quality <0xFC>,
            func3_AO_4_simulate_status_limit   <0x03>,
			func3_AO_4_simulate_value, 
			func3_AO_4_simulation_enabled
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_increase_close 
{
	BLOCK func3_AO_4;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_increase_close
		}
	}
}

COMMAND write_func3_AO_4_increase_close 
{
	BLOCK func3_AO_4;
	INDEX 36;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_increase_close
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_out 
{
	BLOCK func3_AO_4;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_out_value,
            func3_AO_4_out_status_quality <0xFC>,
            func3_AO_4_out_status_limit   <0x03>
		}
	}
}

COMMAND write_func3_AO_4_out 
{
	BLOCK func3_AO_4;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_out_value,
            func3_AO_4_out_status_quality <0xFC>,
            func3_AO_4_out_status_limit   <0x03>
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_AO_4_out_scale 
{
	BLOCK func3_AO_4;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_AO_4_out_upper_range_value, func3_AO_4_out_lower_range_value,
			func3_AO_4_out_unit, func3_AO_4_out_decimal_point
		}
	}
}

COMMAND write_func3_AO_4_out_scale
{
	BLOCK func3_AO_4;
	INDEX 38;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_AO_4_out_upper_range_value, func3_AO_4_out_lower_range_value,
			func3_AO_4_out_unit, func3_AO_4_out_decimal_point
		}
		REPLY
		{
		}
	}
}

/*   */

MENU Menu_AO_off
{
	LABEL "Analog Output";
	ITEMS
	{
		OfflineWindow_AO_1_geral,
		OfflineWindow_AO_2_geral,
		OfflineWindow_AO_3_geral,
		OfflineWindow_AO_4_geral
	}
}

MENU Menu_AO_on
{
	LABEL "Analog Output";
	ITEMS
	{
		OnlineDialog_AO_1_setting,
		OnlineDialog_AO_2_setting,
		OnlineDialog_AO_3_setting,
		OnlineDialog_AO_4_setting
	}
}

MENU Menu_simulate_AO
{
	LABEL "Simulate-AO";
	ITEMS
	{
		OnlineDialog_simulation_AO_1,
		OnlineDialog_simulation_AO_2,
		OnlineDialog_simulation_AO_3,
		OnlineDialog_simulation_AO_4
	}
}

 /* AO 1 */

MENU Page_diagnosis_func3_AO_1
{
    LABEL        "AO-1";
    ITEMS
    {
        func3_AO_1_blk_object,
        func3_AO_1_blk_parent_class,
        func3_AO_1_blk_class,
        func3_AO_1_blk_dd_reference,
        func3_AO_1_blk_dd_rev,
        func3_AO_1_blk_profile,
        func3_AO_1_blk_profile_rev,
        func3_AO_1_st_rev,
        func3_AO_1_actual_mode,
        func3_AO_1_simulation_enabled (READ_ONLY)
    }
}

MENU OfflineWindow_AO_1_geral
{
	LABEL "AO-1"; 
	ITEMS
	{
		Page_basic_AO_1,
		Page_scale_AO_1,
		Page_advanced_AO_1
	}
}

MENU Page_basic_AO_1
{
	LABEL [MC_Tab_basic];
	ITEMS
	{
		Group_target_mode_AO_1,
//		Group_channel_in_AO_1,
		Group_channel_out_AO_1,
		Group_direction_AO_1
	}
}

MENU Page_scale_AO_1
{
	LABEL "Scales/Units";
	ITEMS
	{
		Group_scale_pv_AO_1,
		Group_scale_out_AO_1
	}
}

MENU Page_advanced_AO_1
{
	LABEL [MC_Tab_advanced];
	ITEMS
	{
		Group_fault_set_AO_1,
		Group_batch_AO_1
	}
}

MENU Page_batch_AO_1
{
	LABEL [MC_Batch_Info];
	ITEMS
	{
		Group_batch_AO_1
	}
}


MENU Group_target_mode_AO_1
{
	LABEL "Config Block Mode";
	ITEMS
	{
		func3_AO_1_target_mode,
		COLUMNBREAK,
		method_write_target_mode_AO_1
	}
}

//MENU Group_channel_in_AO_1
//{
//	LABEL		"Select Channel";
//	ITEMS
//	{
//		func3_AO_1_in_channel,
//		COLUMNBREAK,
//		method_write_channel_in_out_AO_1
//	}
//}

MENU Group_channel_out_AO_1
{
	LABEL		"Select Channel";
	ITEMS
	{
		func3_AO_1_out_channel,
		COLUMNBREAK,
		method_write_channel_in_out_AO_1
	}
}

MENU Group_scale_pv_AO_1
{
	LABEL 	"Set Scale of Input Value";
	ITEMS
	{
		func3_AO_1_pv_upper_range_value,
		func3_AO_1_pv_lower_range_value,
		func3_AO_1_pv_unit,
		COLUMNBREAK,
		method_write_scale_in_AO_1
	}
}

MENU Group_scale_out_AO_1
{
	LABEL 	"Set Scale of Output Value";
	ITEMS
	{
		func3_AO_1_out_upper_range_value,
		func3_AO_1_out_lower_range_value,
		func3_AO_1_out_unit (READ_ONLY),
		COLUMNBREAK,
		method_write_scale_out_AO_1
	}
}

MENU Group_direction_AO_1
{
	LABEL		"Select Positioner/Actuator Action";
	ITEMS
	{
		func3_AO_1_increase_close,
		COLUMNBREAK,
		method_write_direction_AO_1
	}
}


MENU Group_fault_set_AO_1
{
	LABEL 	"Set Fail Safe Values";
	ITEMS
	{
		func3_AO_1_fsafe_type,
		func3_AO_1_fsafe_value,
		func3_AO_1_fsafe_time,
		COLUMNBREAK,
		method_write_fail_AO_1
	}
}

MENU Group_batch_AO_1
{
	LABEL		"Define Batch Information";
	ITEMS
	{
		func3_AO_1_batch_id,
		func3_AO_1_batch_unit,
		func3_AO_1_batch_operation,
		func3_AO_1_batch_phase,
		COLUMNBREAK,
		method_write_batch_AO_1
	}
}

MENU OnlineDialog_AO_1_setting
{
	LABEL		"AO-1 Block Mode";
	ITEMS
	{
		Page_mode_AO_1,
		Page_actuator_AO_1,
/*		Page_simulation_AO_1 */
	}
}

MENU Page_mode_AO_1
{
	LABEL		"Config Block Mode";
	ITEMS
	{
		Group_mode_AO_1,
		Group_output_AO_1,
		Group_setpoint_AO_1,
		Group_rcas_in_AO_1,
		Group_rcas_out_AO_1,
/*		Group_set_desv_AO_1, 
		Group_readback_AO_1,*/
		method_set
	}
}


MENU Group_mode_AO_1
{
	LABEL		"Config Block Mode";
	ITEMS
	{
		func3_AO_1_target_mode,
		COLUMNBREAK,
		func3_AO_1_actual_mode
	}
}

MENU Group_output_AO_1
{
	LABEL		"Set Output (MAN)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_1_out_value,
		COLUMNBREAK,
		func3_AO_1_out_status_quality,
        func3_AO_1_out_status_limit
	}
}

MENU Group_setpoint_AO_1
{
	LABEL		"Set Setpoint from Operator - SP (AUTO)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_1_setpoint_value,
		COLUMNBREAK,
		func3_AO_1_setpoint_status_quality,
        func3_AO_1_setpoint_status_limit
	}
}

MENU Group_rcas_in_AO_1
{
	LABEL		"Set Setpoint from Remote Station - RCAS_IN (RCAS)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_1_rcas_in_value,
		COLUMNBREAK,
		func3_AO_1_rcas_in_status_quality,
        func3_AO_1_rcas_in_status_limit
	}
}

MENU Group_rcas_out_AO_1
{
	LABEL		"From RCAS_OUT to Remote Station"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_1_rcas_out_value,
		COLUMNBREAK,
		func3_AO_1_rcas_out_status_quality,
        func3_AO_1_rcas_out_status_limit
	}
}

MENU Group_set_desv_AO_1
{
	LABEL		[func_ao_setpoint_deviation]; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_1_setpoint_deviation
	}
}

MENU Page_actuator_AO_1
{
	LABEL		"Feedback";
	ITEMS
	{
		Group_readback_AO_1,
		Group_pos_d_AO_1,
		Group_set_desv_AO_1,
		func3_AO_1_check_back,
		func3_AO_1_current_state_alarm_sum
	}
}

MENU Group_pos_d_AO_1
{
	LABEL 		"Discrete Valve Position";
	ITEMS
	{
		func3_AO_1_position_discrete_value,
		COLUMNBREAK,
		func3_AO_1_position_discrete_status_quality,
        func3_AO_1_position_discrete_status_limit
	}
}

MENU Group_readback_AO_1
{
	LABEL		"Readback to Transducer"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_1_readback_value,
		COLUMNBREAK,
		func3_AO_1_readback_status_quality,
        func3_AO_1_readback_status_limit
	}
}

MENU OnlineDialog_simulation_AO_1
{
	LABEL		"Simulate AO-1"; /* "Simulate AI"; */
	ITEMS
	{
		Page_simulation_AO_1,
		Page_simulation_out_AO_1
	}
}

MENU Page_simulation_AO_1
{
	LABEL		[menu_dialog_simulation_input];
	ITEMS
	{
		func3_AO_1_simulation_enabled,
		Group_simulate_value_AO_1,
		method_set
	}
}

MENU Group_simulate_value_AO_1
{
	LABEL 	"Simulation Value";
	ITEMS
	{
		func3_AO_1_simulate_value,
		COLUMNBREAK,
		func3_AO_1_simulate_status_quality,
        func3_AO_1_simulate_status_limit
	}
}

MENU Page_simulation_out_AO_1
{
	LABEL		[menu_dialog_simulation_output];
	ITEMS
	{
		Group_mode_AO_1,
		Group_readback_AO_1,
		method_set
	}
}

METHOD method_set_status_limit_func3_AO_1
{
	CLASS		INPUT;
	DEFINITION
	{
		int	quality;
		int block_mode;			/* !!! temp.: bis Methoden mit Aufrufparametern funktionieren !!! */

		quality = ivar_value(func3_AO_1_setpoint_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_1_setpoint_status_limit, 0);

		quality = ivar_value(func3_AO_1_rcas_in_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_1_rcas_in_status_limit, 0);

		quality = ivar_value(func3_AO_1_simulate_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_1_simulate_status_limit, 0);

		block_mode	= ivar_value(func3_AO_1_target_mode);
		quality		= ivar_value(func3_AO_1_out_status_quality);
		if (((block_mode == BLOCK_MODE_MAN) || (block_mode == BLOCK_MODE_LO)) && ((quality == 0x20) || (quality == 0x30)))
			iassign(func3_AO_1_out_status_limit, 0);
	}
}

METHOD method_write_target_mode_AO_1
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_1_target_mode);
		ReadCommand(read_func3_AO_1_target_mode);
	}
}

METHOD method_write_channel_in_out_AO_1
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_1_out_channel);
		ReadCommand(read_func3_AO_1_out_channel);
		sassign(func3_AO_1_in_channel, func3_AO_1_out_channel);
		WriteCommand(write_func3_AO_1_in_channel);
		ReadCommand(read_func3_AO_1_in_channel);
	}
}

//METHOD method_write_channel_out_AO_1
//{
//	LABEL "Write";
//	DEFINITION
//	{
//		WriteCommand(write_func3_AO_1_out_channel);
//		ReadCommand(read_func3_AO_1_out_channel);
//	}
//}

METHOD method_write_direction_AO_1
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_1_increase_close);
		ReadCommand(read_func3_AO_1_increase_close);
	}
}


METHOD method_write_scale_in_AO_1
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_1_pv);
		ReadCommand(read_func3_AO_1_pv);
	}
}

METHOD method_write_scale_out_AO_1
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_1_out_scale);
		ReadCommand(read_func3_AO_1_out_scale);
	}
}

METHOD method_write_fail_AO_1
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_1_fsafe_type);
		WriteCommand(write_func3_AO_1_fsafe_time);
		WriteCommand(write_func3_AO_1_fsafe_value);
		ReadCommand(read_func3_AO_1_fsafe_type);
		ReadCommand(read_func3_AO_1_fsafe_time);
		ReadCommand(read_func3_AO_1_fsafe_value);
	}
}

METHOD method_write_batch_AO_1
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_1_batch_information);
	}
}



/* windows */

MENU Page_display_AO_1
{
	LABEL		"AO-1";
	ITEMS
	{
		BarVal_display_readback_AO_1,
		Group_display_readback_AO_1
		Group_display_setpoint_AO_1,
		func3_AO_1_position_discrete_value,
		func3_AO_1_setpoint_deviation,
		func3_AO_1_check_back,
//		BarVal_display_out_AO_1,
		Group_display_out_AO_1
	}
}

MENU BarVal_display_readback_AO_1
{
	LABEL		"Readback to Transducer";
	ITEMS
	{
		func3_AO_1_readback_value,
		func3_AO_1_pv_lower_range_value		(READ_ONLY),
		func3_AO_1_pv_upper_range_value		(READ_ONLY)
	}
}

MENU Group_display_readback_AO_1
{
	LABEL		"Readback to Transducer";
	ITEMS
	{
		func3_AO_1_readback_value,
		COLUMNBREAK,
		func3_AO_1_readback_status_quality,
        func3_AO_1_readback_status_limit
	}
}

MENU Group_display_setpoint_AO_1
{
	LABEL		[func_ao_setpoint_value];
	ITEMS
	{
		func3_AO_1_setpoint_value			(READ_ONLY),
		COLUMNBREAK,
		func3_AO_1_setpoint_status_quality (READ_ONLY),
		func3_AO_1_setpoint_status_limit (READ_ONLY)
	}
}

MENU BarVal_display_out_AO_1
{
	LABEL			"Output";
	ITEMS
	{
		func3_AO_1_out_value					(READ_ONLY),
		func3_AO_1_out_lower_range_value		(READ_ONLY),
		func3_AO_1_out_upper_range_value		(READ_ONLY)
	}
}

MENU Group_display_out_AO_1
{
	LABEL			"Output";
	ITEMS
	{
		func3_AO_1_out_value					(READ_ONLY),
		COLUMNBREAK,
		func3_AO_1_out_status_quality (READ_ONLY),
		func3_AO_1_out_status_limit   (READ_ONLY)
	}
}

/* Menus */

MENU Tab_s_AO_1
{
	LABEL		"AO-1";
	ITEMS
	{
		func3_AO_1_st_rev,
        Tab_s_basic_AO_1,
		Tab_s_advanced_AO_1
	}
}

MENU Tab_s_basic_AO_1
{
	LABEL        [MC_Tab_basic];
	ITEMS
	{
		Tab_s_target_mode_AO_1,
//		Tab_s_channel_in_AO_1,
		Tab_s_channel_out_AO_1,
		Tab_s_direction_AO_1,
		Tab_s_scale_pv_AO_1,
		Tab_s_scale_out_AO_1
	}
}

MENU Tab_s_advanced_AO_1
{
	LABEL        [MC_Tab_advanced];
	ITEMS
	{
		Tab_s_fault_set_AO_1,
		Tab_s_batch_AO_1
	}
}

MENU Tab_s_target_mode_AO_1
{
	LABEL		[MC_Tab_mode_ao];
	ITEMS
	{
		func3_AO_1_target_mode
	}
}

//MENU Tab_s_channel_in_AO_1
//{
//	LABEL		"Select Input";
//	ITEMS
//	{
//		func3_AO_1_in_channel
//	}
//}

MENU Tab_s_channel_out_AO_1
{
	LABEL		"Select Channel";
	ITEMS
	{
		func3_AO_1_out_channel
	}
}

MENU 	Tab_s_scale_pv_AO_1
{
	LABEL "Set Scale of Input Value";
	ITEMS
	{
		func3_AO_1_pv_upper_range_value,
		func3_AO_1_pv_lower_range_value,
		func3_AO_1_pv_unit
	}
}

MENU 	Tab_s_scale_out_AO_1
{
	LABEL "Set Scale of Output Value";
	ITEMS
	{
		func3_AO_1_out_upper_range_value,
		func3_AO_1_out_lower_range_value,
		func3_AO_1_out_unit(READ_ONLY)
	}
}

MENU Tab_s_direction_AO_1
{
	LABEL		"Select Positioner/Actuator Action";
	ITEMS
	{
		func3_AO_1_increase_close
	}
}

MENU Tab_s_fault_set_AO_1
{
	LABEL		"Set Fail Safe Values";
	ITEMS
	{
		func3_AO_1_fsafe_type,
		func3_AO_1_fsafe_time,
		func3_AO_1_fsafe_value
	}
}

MENU Tab_s_batch_AO_1
{
	LABEL		"Define Batch Information";
	ITEMS
	{
		func3_AO_1_batch_id,
		func3_AO_1_batch_unit,
		func3_AO_1_batch_operation,
		func3_AO_1_batch_phase
	}
}

/* AO-2  */

MENU Page_diagnosis_func3_AO_2
{
    LABEL        "AO-2";
    ITEMS
    {
        func3_AO_2_blk_object,
        func3_AO_2_blk_parent_class,
        func3_AO_2_blk_class,
        func3_AO_2_blk_dd_reference,
        func3_AO_2_blk_dd_rev,
        func3_AO_2_blk_profile,
        func3_AO_2_blk_profile_rev,
        func3_AO_2_st_rev,
        func3_AO_2_actual_mode,
        func3_AO_2_simulation_enabled (READ_ONLY)
    }
}

MENU OfflineWindow_AO_2_geral
{
	LABEL "AO-2";
	ITEMS
	{
		Page_basic_AO_2,
		Page_scale_AO_2,
		Page_advanced_AO_2
	}
}

MENU Page_basic_AO_2
{
	LABEL [MC_Tab_basic];
	ITEMS
	{
		Group_target_mode_AO_2,
//		Group_channel_in_AO_2,
		Group_channel_out_AO_2,
		Group_direction_AO_2
	}
}

MENU Page_scale_AO_2
{
	LABEL "Scales/Units";
	ITEMS
	{
		Group_scale_pv_AO_2,
		Group_scale_out_AO_2
	}
}

MENU Page_advanced_AO_2
{
	LABEL [MC_Tab_advanced];
	ITEMS
	{
		Group_fault_set_AO_2,
		Group_batch_AO_2
	}
}

MENU Page_batch_AO_2
{
	LABEL [MC_Batch_Info];
	ITEMS
	{
		Group_batch_AO_2
	}
}


MENU Group_target_mode_AO_2
{
	LABEL "Config Block Mode";
	ITEMS
	{
		func3_AO_2_target_mode,
		COLUMNBREAK,
		method_write_target_mode_AO_2
	}
}

//MENU Group_channel_in_AO_2
//{
//	LABEL		"Select Channel";
//	ITEMS
//	{
//		func3_AO_2_in_channel,
//		COLUMNBREAK,
//		method_write_channel_in_out_AO_2
//	}
//}

MENU Group_channel_out_AO_2
{
	LABEL		"Select Channel";
	ITEMS
	{
		func3_AO_2_out_channel,
		COLUMNBREAK,
		method_write_channel_in_out_AO_2
	}
}

MENU Group_scale_pv_AO_2
{
	LABEL 	"Set Scale of Input Value";
	ITEMS
	{
		func3_AO_2_pv_upper_range_value,
		func3_AO_2_pv_lower_range_value,
		func3_AO_2_pv_unit,
		COLUMNBREAK,
		method_write_scale_in_AO_2
	}
}

MENU Group_scale_out_AO_2
{
	LABEL 	"Set Scale of Output Value";
	ITEMS
	{
		func3_AO_2_out_upper_range_value,
		func3_AO_2_out_lower_range_value,
		func3_AO_2_out_unit (READ_ONLY),
		COLUMNBREAK,
		method_write_scale_out_AO_2
	}
}

MENU Group_direction_AO_2
{
	LABEL		"Select Positioner/Actuator Action";
	ITEMS
	{
		func3_AO_2_increase_close,
		COLUMNBREAK,
		method_write_direction_AO_2
	}
}


MENU Group_fault_set_AO_2
{
	LABEL 	"Set Fail Safe Values";
	ITEMS
	{
		func3_AO_2_fsafe_type,
		func3_AO_2_fsafe_value,
		func3_AO_2_fsafe_time,
		COLUMNBREAK,
		method_write_fail_AO_2
	}
}

MENU Group_batch_AO_2
{
	LABEL		"Define Batch Information";
	ITEMS
	{
		func3_AO_2_batch_id,
		func3_AO_2_batch_unit,
		func3_AO_2_batch_operation,
		func3_AO_2_batch_phase,
		COLUMNBREAK,
		method_write_batch_AO_2
	}
}


MENU OnlineDialog_AO_2_setting
{
	LABEL		"AO-2 Block Mode" ;
	ITEMS
	{
		Page_mode_AO_2,
		Page_actuator_AO_2
/*		Page_simulation_AO_2 */
	}
}

MENU Page_mode_AO_2
{
	LABEL		"Config Block Mode";
	ITEMS
	{
		Group_mode_AO_2,
		Group_output_AO_2,
		Group_setpoint_AO_2,
		Group_rcas_in_AO_2,
		Group_rcas_out_AO_2,
/*		Group_set_desv_AO_2,
		Group_readback_AO_2, */
		method_set
	}
}


MENU Group_mode_AO_2
{
	LABEL		"Config Block Mode";
	ITEMS
	{
		func3_AO_2_target_mode,
		COLUMNBREAK,
		func3_AO_2_actual_mode
	}
}

MENU Group_output_AO_2
{
	LABEL		"Set Output (MAN)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_2_out_value,
		COLUMNBREAK,
		func3_AO_2_out_status_quality,
        func3_AO_2_out_status_limit
	}
}

MENU Group_setpoint_AO_2
{
	LABEL		"Set Setpoint from Operator - SP (AUTO)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_2_setpoint_value,
		COLUMNBREAK,
        func3_AO_2_setpoint_status_quality ,
        func3_AO_2_setpoint_status_limit
	}
}

MENU Group_rcas_in_AO_2
{
	LABEL		"Set Setpoint from Remote Station - RCAS_IN (RCAS)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_2_rcas_in_value,
		COLUMNBREAK,
		func3_AO_2_rcas_in_status_quality,
        func3_AO_2_rcas_in_status_limit
	}
}

MENU Group_rcas_out_AO_2
{
	LABEL		"From RCAS_OUT to Remote Station"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_2_rcas_out_value,
		COLUMNBREAK,
		func3_AO_2_rcas_out_status_quality,
        func3_AO_2_rcas_out_status_limit
	}
}

MENU Group_set_desv_AO_2
{
	LABEL		[func_ao_setpoint_deviation]; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_2_setpoint_deviation
	}
}

MENU Page_actuator_AO_2
{
	LABEL		"Feedback";
	ITEMS
	{
		Group_readback_AO_2,
		Group_pos_d_AO_2,
		Group_set_desv_AO_2,
		func3_AO_2_check_back,
		func3_AO_2_current_state_alarm_sum
	}
}

MENU Group_pos_d_AO_2
{
	LABEL 		"Discrete Valve Position";
	ITEMS
	{
		func3_AO_2_position_discrete_value,
		COLUMNBREAK,
		func3_AO_2_position_discrete_status_quality,
        func3_AO_2_position_discrete_status_limit
	}
}

MENU Group_readback_AO_2
{
	LABEL		"Readback to Transducer"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_2_readback_value,
		COLUMNBREAK,
		func3_AO_2_readback_status_quality,
        func3_AO_2_readback_status_limit
	}
}

MENU OnlineDialog_simulation_AO_2
{
	LABEL		"Simulate AO-2"; /* "Simulate AI"; */
	ITEMS
	{
		Page_simulation_AO_2,
		Page_simulation_out_AO_2
	}
}

MENU Page_simulation_AO_2
{
	LABEL		[menu_dialog_simulation_input];
	ITEMS
	{
		func3_AO_2_simulation_enabled,
		Group_simulate_value_AO_2,
		method_set
	}
}

MENU Group_simulate_value_AO_2
{
	LABEL 	"Simulation Value";
	ITEMS
	{
		func3_AO_2_simulate_value,
		COLUMNBREAK,
		func3_AO_2_simulate_status_quality,
        func3_AO_2_simulate_status_limit
	}
}

MENU Page_simulation_out_AO_2
{
	LABEL		[menu_dialog_simulation_output];
	ITEMS
	{
		Group_mode_AO_2,
		Group_readback_AO_2,
		method_set
	}
}

METHOD method_set_status_limit_func3_AO_2
{
	CLASS		INPUT;
	DEFINITION
	{
		int	quality;
		int block_mode;			/* !!! temp.: bis Methoden mit Aufrufparametern funktionieren !!! */

		quality = ivar_value(func3_AO_2_setpoint_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_2_setpoint_status_limit, 0);

		quality = ivar_value(func3_AO_2_rcas_in_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_2_rcas_in_status_limit, 0);

		quality = ivar_value(func3_AO_2_simulate_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_2_simulate_status_limit, 0);

		block_mode	= ivar_value(func3_AO_2_target_mode);
		quality		= ivar_value(func3_AO_2_out_status_quality);
		if (((block_mode == BLOCK_MODE_MAN) || (block_mode == BLOCK_MODE_LO)) && ((quality == 0x20) || (quality == 0x30)))
			iassign(func3_AO_2_out_status_limit, 0);
	}
}

METHOD method_write_target_mode_AO_2
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_2_target_mode);
		ReadCommand(read_func3_AO_2_target_mode);
	}
}

METHOD method_write_channel_in_out_AO_2
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_2_out_channel);
		ReadCommand(read_func3_AO_2_out_channel);
		sassign(func3_AO_2_in_channel, func3_AO_2_out_channel);
		WriteCommand(write_func3_AO_2_in_channel);
		ReadCommand(read_func3_AO_2_in_channel);
	}
}

//METHOD method_write_channel_out_AO_2
//{
//	LABEL "Write";
//	DEFINITION
//	{
//		WriteCommand(write_func3_AO_2_out_channel);
//		ReadCommand(read_func3_AO_2_out_channel);
//	}
//}

METHOD method_write_direction_AO_2
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_2_increase_close);
		ReadCommand(read_func3_AO_2_increase_close);
	}
}


METHOD method_write_scale_in_AO_2
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_2_pv);
		ReadCommand(read_func3_AO_2_pv);
	}
}

METHOD method_write_scale_out_AO_2
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_2_out_scale);
		ReadCommand(read_func3_AO_2_out_scale);
	}
}

METHOD method_write_fail_AO_2
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_2_fsafe_type);
		WriteCommand(write_func3_AO_2_fsafe_time);
		WriteCommand(write_func3_AO_2_fsafe_value);
		ReadCommand(read_func3_AO_2_fsafe_type);
		ReadCommand(read_func3_AO_2_fsafe_time);
		ReadCommand(read_func3_AO_2_fsafe_value);
	}
}

METHOD method_write_batch_AO_2
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_2_batch_information);
	}
}


/* windows */

MENU Page_display_AO_2
{
	LABEL		"AO-2";
	ITEMS
	{
		BarVal_display_readback_AO_2,
		Group_display_readback_AO_2
		Group_display_setpoint_AO_2,
		func3_AO_2_position_discrete_value,
		func3_AO_2_setpoint_deviation,
		func3_AO_2_check_back,
//		BarVal_display_out_AO_2,
		Group_display_out_AO_2
	}
}

MENU BarVal_display_readback_AO_2
{
	LABEL			"Readback to Transducer"; /* [func_ao_readback_value]; */
	ITEMS
	{
		func3_AO_2_readback_value,
		func3_AO_2_pv_lower_range_value		(READ_ONLY),
		func3_AO_2_pv_upper_range_value		(READ_ONLY)
	}
}

MENU Group_display_readback_AO_2
{
	LABEL			"Readback to Transducer"; /* [func_ao_readback_value]; */
	ITEMS
	{
		func3_AO_2_readback_value,
		COLUMNBREAK,
		func3_AO_2_readback_status_quality,
        func3_AO_2_readback_status_limit
	}
}

MENU Group_display_setpoint_AO_2
{
	LABEL		[func_ao_setpoint_value];
	ITEMS
	{
		func3_AO_2_setpoint_value			(READ_ONLY),
		COLUMNBREAK,
        func3_AO_2_setpoint_status_quality  (READ_ONLY),
        func3_AO_2_setpoint_status_limit    (READ_ONLY)
	}
}

MENU BarVal_display_out_AO_2
{
	LABEL			"Output"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_2_out_value					(READ_ONLY),
		func3_AO_2_out_lower_range_value		(READ_ONLY),
		func3_AO_2_out_upper_range_value		(READ_ONLY)
	}
}

MENU Group_display_out_AO_2
{
	LABEL			"Output"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_2_out_value					(READ_ONLY),
		COLUMNBREAK,
		func3_AO_2_out_status_quality (READ_ONLY),
		func3_AO_2_out_status_limit   (READ_ONLY)
	}
}

/* Menus */

MENU Tab_s_AO_2
{
	LABEL		"AO-2";
	ITEMS
	{
		func3_AO_2_st_rev,
		Tab_s_basic_AO_2,
		Tab_s_advanced_AO_2
	}
}

MENU Tab_s_basic_AO_2
{
	LABEL        [MC_Tab_basic];
	ITEMS
	{
		Tab_s_target_mode_AO_2,
//		Tab_s_channel_in_AO_2,
		Tab_s_channel_out_AO_2,
		Tab_s_direction_AO_2,
		Tab_s_scale_pv_AO_2,
		Tab_s_scale_out_AO_2
	}
}

MENU Tab_s_advanced_AO_2
{
	LABEL        [MC_Tab_advanced];
	ITEMS
	{
		Tab_s_fault_set_AO_2,
		Tab_s_batch_AO_2
	}
}

MENU Tab_s_target_mode_AO_2
{
	LABEL		[MC_Tab_mode_ao];
	ITEMS
	{
		func3_AO_2_target_mode
	}
}

//MENU Tab_s_channel_in_AO_2
//{
//	LABEL		"Select Input";
//	ITEMS
//	{
//		func3_AO_2_in_channel
//	}
//}

MENU Tab_s_channel_out_AO_2
{
	LABEL		"Select Channel";
	ITEMS
	{
		func3_AO_2_out_channel
	}
}

MENU 	Tab_s_scale_pv_AO_2
{
	LABEL "Set Scale of Input Value";
	ITEMS
	{
		func3_AO_2_pv_upper_range_value,
		func3_AO_2_pv_lower_range_value,
		func3_AO_2_pv_unit
	}
}

MENU 	Tab_s_scale_out_AO_2
{
	LABEL "Set Scale of Output Value";
	ITEMS
	{
		func3_AO_2_out_upper_range_value,
		func3_AO_2_out_lower_range_value,
		func3_AO_2_out_unit (READ_ONLY)
	}
}

MENU Tab_s_direction_AO_2
{
	LABEL		"Select Positioner/Actuator Action";
	ITEMS
	{
		func3_AO_2_increase_close
	}
}

MENU Tab_s_fault_set_AO_2
{
	LABEL		"Set Fail Safe Values";
	ITEMS
	{
		func3_AO_2_fsafe_type,
		func3_AO_2_fsafe_time,
		func3_AO_2_fsafe_value
	}
}

MENU Tab_s_batch_AO_2
{
	LABEL		"Define Batch Information";
	ITEMS
	{
		func3_AO_2_batch_id,
		func3_AO_2_batch_unit,
		func3_AO_2_batch_operation,
		func3_AO_2_batch_phase
	}
}

/* AO-3  */

MENU Page_diagnosis_func3_AO_3
{
    LABEL        "AO-3";
    ITEMS
    {
        func3_AO_3_blk_object,
        func3_AO_3_blk_parent_class,
        func3_AO_3_blk_class,
        func3_AO_3_blk_dd_reference,
        func3_AO_3_blk_dd_rev,
        func3_AO_3_blk_profile,
        func3_AO_3_blk_profile_rev,
        func3_AO_3_st_rev,
        func3_AO_3_actual_mode,
        func3_AO_3_simulation_enabled (READ_ONLY)
    }
}

MENU OfflineWindow_AO_3_geral
{
	LABEL "AO-3";
	ITEMS
	{
		Page_basic_AO_3,
		Page_scale_AO_3,
		Page_advanced_AO_3
	}
}

MENU Page_basic_AO_3
{
	LABEL [MC_Tab_basic];
	ITEMS
	{
		Group_target_mode_AO_3,
//		Group_channel_in_AO_3,
		Group_channel_out_AO_3,
		Group_direction_AO_3
	}
}

MENU Page_scale_AO_3
{
	LABEL "Scales/Units";
	ITEMS
	{
		Group_scale_pv_AO_3,
		Group_scale_out_AO_3
	}
}

MENU Page_advanced_AO_3
{
	LABEL [MC_Tab_advanced];
	ITEMS
	{
		Group_fault_set_AO_3,
		Group_batch_AO_3
	}
}

MENU Page_batch_AO_3
{
	LABEL [MC_Batch_Info];
	ITEMS
	{
		Group_batch_AO_3
	}
}


MENU Group_target_mode_AO_3
{
	LABEL "Config Block Mode";
	ITEMS
	{
		func3_AO_3_target_mode,
		COLUMNBREAK,
		method_write_target_mode_AO_3
	}
}

//MENU Group_channel_in_AO_3
//{
//	LABEL		"Select Channel";
//	ITEMS
//	{
//		func3_AO_3_in_channel,
//		COLUMNBREAK,
//		method_write_channel_in_out_AO_3
//	}
//}

MENU Group_channel_out_AO_3
{
	LABEL		"Select Channel";
	ITEMS
	{
		func3_AO_3_out_channel,
		COLUMNBREAK,
		method_write_channel_in_out_AO_3
	}
}

MENU Group_scale_pv_AO_3
{
	LABEL 	"Set Scale of Input Value";
	ITEMS
	{
		func3_AO_3_pv_upper_range_value,
		func3_AO_3_pv_lower_range_value,
		func3_AO_3_pv_unit,
		COLUMNBREAK,
		method_write_scale_in_AO_3
	}
}

MENU Group_scale_out_AO_3
{
	LABEL 	"Set Scale of Output Value";
	ITEMS
	{
		func3_AO_3_out_upper_range_value,
		func3_AO_3_out_lower_range_value,
		func3_AO_3_out_unit (READ_ONLY),
		COLUMNBREAK,
		method_write_scale_out_AO_3
	}
}

MENU Group_direction_AO_3
{
	LABEL		"Select Positioner/Actuator Action";
	ITEMS
	{
		func3_AO_3_increase_close,
		COLUMNBREAK,
		method_write_direction_AO_3
	}
}


MENU Group_fault_set_AO_3
{
	LABEL 	"Set Fail Safe Values";
	ITEMS
	{
		func3_AO_3_fsafe_type,
		func3_AO_3_fsafe_value,
		func3_AO_3_fsafe_time,
		COLUMNBREAK,
		method_write_fail_AO_3
	}
}

MENU Group_batch_AO_3
{
	LABEL		"Define Batch Information";
	ITEMS
	{
		func3_AO_3_batch_id,
		func3_AO_3_batch_unit,
		func3_AO_3_batch_operation,
		func3_AO_3_batch_phase,
		COLUMNBREAK,
		method_write_batch_AO_3
	}
}


MENU OnlineDialog_AO_3_setting
{
	LABEL		"AO-3 Block Mode" ;
	ITEMS
	{
		Page_mode_AO_3,
		Page_actuator_AO_3,
/*		Page_simulation_AO_3 */
	}
}

MENU Page_mode_AO_3
{
	LABEL		"Config Block Mode";
	ITEMS
	{
		Group_mode_AO_3,
		Group_output_AO_3,
		Group_setpoint_AO_3,
		Group_rcas_in_AO_3,
		Group_rcas_out_AO_3,
/*		Group_set_desv_AO_3,
		Group_readback_AO_3, */
		method_set
	}
}


MENU Group_mode_AO_3
{
	LABEL		"Config Block Mode";
	ITEMS
	{
		func3_AO_3_target_mode,
		COLUMNBREAK,
		func3_AO_3_actual_mode
	}
}

MENU Group_output_AO_3
{
	LABEL		"Set Output (MAN)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_3_out_value,
		COLUMNBREAK,
		func3_AO_3_out_status_quality,
        func3_AO_3_out_status_limit
	}
}

MENU Group_setpoint_AO_3
{
	LABEL		"Set Setpoint from Operator - SP (AUTO)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_3_setpoint_value,
		COLUMNBREAK,
		func3_AO_3_setpoint_status_quality,
        func3_AO_3_setpoint_status_limit
	}
}

MENU Group_rcas_in_AO_3
{
	LABEL		"Set Setpoint from Remote Station - RCAS_IN (RCAS)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_3_rcas_in_value,
		COLUMNBREAK,
		func3_AO_3_rcas_in_status_quality,
        func3_AO_3_rcas_in_status_limit
	}
}

MENU Group_rcas_out_AO_3
{
	LABEL		"From RCAS_OUT to Remote Station"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_3_rcas_out_value,
		COLUMNBREAK,
		func3_AO_3_rcas_out_status_quality,
        func3_AO_3_rcas_out_status_limit
	}
}

MENU Group_set_desv_AO_3
{
	LABEL		[func_ao_setpoint_deviation]; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_3_setpoint_deviation
	}
}

MENU Page_actuator_AO_3
{
	LABEL		"Feedback";
	ITEMS
	{
		Group_readback_AO_3,
		Group_pos_d_AO_3,
		Group_set_desv_AO_3,
		func3_AO_3_check_back,
		func3_AO_3_current_state_alarm_sum
	}
}

MENU Group_pos_d_AO_3
{
	LABEL 		"Discrete Valve Position";
	ITEMS
	{
		func3_AO_3_position_discrete_value,
		COLUMNBREAK,
		func3_AO_3_position_discrete_status_quality,
        func3_AO_3_position_discrete_status_limit
	}
}

MENU Group_readback_AO_3
{
	LABEL		"Readback to Transducer"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_3_readback_value,
		COLUMNBREAK,
		func3_AO_3_readback_status_quality,
        func3_AO_3_readback_status_limit
	}
}

MENU OnlineDialog_simulation_AO_3
{
	LABEL		"Simulate AO-3"; /* "Simulate AI"; */
	ITEMS
	{
		Page_simulation_AO_3,
		Page_simulation_out_AO_3
	}
}

MENU Page_simulation_AO_3
{
	LABEL		[menu_dialog_simulation_input];
	ITEMS
	{
		func3_AO_3_simulation_enabled,
		Group_simulate_value_AO_3,
		method_set
	}
}

MENU Group_simulate_value_AO_3
{
	LABEL 	"Simulation Value";
	ITEMS
	{
		func3_AO_3_simulate_value,
		COLUMNBREAK,
		func3_AO_3_simulate_status_quality,
        func3_AO_3_simulate_status_limit
	}
}

MENU Page_simulation_out_AO_3
{
	LABEL		[menu_dialog_simulation_output];
	ITEMS
	{
		Group_mode_AO_3,
		Group_readback_AO_3,
		method_set
	}
}

METHOD method_set_status_limit_func3_AO_3
{
	CLASS		INPUT;
	DEFINITION
	{
		int	quality;
		int block_mode;			/* !!! temp.: bis Methoden mit Aufrufparametern funktionieren !!! */

		quality = ivar_value(func3_AO_3_setpoint_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_3_setpoint_status_limit, 0);

		quality = ivar_value(func3_AO_3_rcas_in_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_3_rcas_in_status_limit, 0);

		quality = ivar_value(func3_AO_3_simulate_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_3_simulate_status_limit, 0);

		block_mode	= ivar_value(func3_AO_3_target_mode);
		quality		= ivar_value(func3_AO_3_out_status_quality);
		if (((block_mode == BLOCK_MODE_MAN) || (block_mode == BLOCK_MODE_LO)) && ((quality == 0x20) || (quality == 0x30)))
			iassign(func3_AO_3_out_status_limit, 0);
	}
}

METHOD method_write_target_mode_AO_3
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_3_target_mode);
		ReadCommand(read_func3_AO_3_target_mode);
	}
}

METHOD method_write_channel_in_out_AO_3
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_3_out_channel);
		ReadCommand(read_func3_AO_3_out_channel);
		sassign(func3_AO_3_in_channel, func3_AO_3_out_channel);
		WriteCommand(write_func3_AO_3_in_channel);
		ReadCommand(read_func3_AO_3_in_channel);
	}
}

//METHOD method_write_channel_out_AO_3
//{
//	LABEL "Write";
//	DEFINITION
//	{
//		WriteCommand(write_func3_AO_3_out_channel);
//		ReadCommand(read_func3_AO_3_out_channel);
//	}
//}

METHOD method_write_direction_AO_3
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_3_increase_close);
		ReadCommand(read_func3_AO_3_increase_close);
	}
}


METHOD method_write_scale_in_AO_3
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_3_pv);
		ReadCommand(read_func3_AO_3_pv);
	}
}

METHOD method_write_scale_out_AO_3
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_3_out_scale);
		ReadCommand(read_func3_AO_3_out_scale);
	}
}

METHOD method_write_fail_AO_3
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_3_fsafe_type);
		WriteCommand(write_func3_AO_3_fsafe_time);
		WriteCommand(write_func3_AO_3_fsafe_value);
		ReadCommand(read_func3_AO_3_fsafe_type);
		ReadCommand(read_func3_AO_3_fsafe_time);
		ReadCommand(read_func3_AO_3_fsafe_value);
	}
}

METHOD method_write_batch_AO_3
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_3_batch_information);
	}
}

/* windows */

MENU Page_display_AO_3
{
	LABEL		"AO-3";
	ITEMS
	{
		BarVal_display_readback_AO_3,
		Group_display_readback_AO_3
		Group_display_setpoint_AO_3,
		func3_AO_3_position_discrete_value,
		func3_AO_3_setpoint_deviation,
		func3_AO_3_check_back,
//		BarVal_display_out_AO_3,
		Group_display_out_AO_3
	}
}

MENU BarVal_display_readback_AO_3
{
	LABEL			"Readback to Transducer";
	ITEMS
	{
		func3_AO_3_readback_value,
		func3_AO_3_pv_lower_range_value		(READ_ONLY),
		func3_AO_3_pv_upper_range_value		(READ_ONLY)
	}
}

MENU Group_display_readback_AO_3
{
	LABEL			"Readback to Transducer";
	ITEMS
	{
		func3_AO_3_readback_value,
		COLUMNBREAK,
		func3_AO_3_readback_status_quality,
        func3_AO_3_readback_status_limit
	}
}

MENU Group_display_setpoint_AO_3
{
	LABEL		[func_ao_setpoint_value];
	ITEMS
	{
		func3_AO_3_setpoint_value			(READ_ONLY),
		COLUMNBREAK,
		func3_AO_3_setpoint_status_quality (READ_ONLY),
		func3_AO_3_setpoint_status_limit   (READ_ONLY)
	}
}

MENU BarVal_display_out_AO_3
{
	LABEL			"Output";
	ITEMS
	{
		func3_AO_3_out_value					(READ_ONLY),
		func3_AO_3_out_lower_range_value		(READ_ONLY),
		func3_AO_3_out_upper_range_value		(READ_ONLY)
	}
}

MENU Group_display_out_AO_3
{
	LABEL			"Output";
	ITEMS
	{
		func3_AO_3_out_value					(READ_ONLY),
		COLUMNBREAK,
		func3_AO_3_out_status_quality (READ_ONLY),
		func3_AO_3_out_status_limit   (READ_ONLY)
	}
}


/* Menus */

MENU Tab_s_AO_3
{
	LABEL		"AO-3";
	ITEMS
	{
		func3_AO_3_st_rev,
		Tab_s_basic_AO_3,
		Tab_s_advanced_AO_3
	}
}

MENU Tab_s_basic_AO_3
{
	LABEL        [MC_Tab_basic];
	ITEMS
	{
		Tab_s_target_mode_AO_3,
//		Tab_s_channel_in_AO_3,
		Tab_s_channel_out_AO_3,
		Tab_s_direction_AO_3,
		Tab_s_scale_pv_AO_3,
		Tab_s_scale_out_AO_3
	}
}

MENU Tab_s_advanced_AO_3
{
	LABEL        [MC_Tab_advanced];
	ITEMS
	{
		Tab_s_fault_set_AO_3,
		Tab_s_batch_AO_3
	}
}

MENU Tab_s_target_mode_AO_3
{
	LABEL		[MC_Tab_mode_ao];
	ITEMS
	{
		func3_AO_3_target_mode
	}
}

//MENU Tab_s_channel_in_AO_3
//{
//	LABEL		"Select Input";
//	ITEMS
//	{
//		func3_AO_3_in_channel
//	}
//}

MENU Tab_s_channel_out_AO_3
{
	LABEL		"Select Channel";
	ITEMS
	{
		func3_AO_3_out_channel
	}
}

MENU 	Tab_s_scale_pv_AO_3
{
	LABEL "Set Scale of Input Value";
	ITEMS
	{
		func3_AO_3_pv_upper_range_value,
		func3_AO_3_pv_lower_range_value,
		func3_AO_3_pv_unit
	}
}

MENU 	Tab_s_scale_out_AO_3
{
	LABEL "Set Scale of Output Value";
	ITEMS
	{
		func3_AO_3_out_upper_range_value,
		func3_AO_3_out_lower_range_value,
		func3_AO_3_out_unit (READ_ONLY)
	}
}

MENU Tab_s_direction_AO_3
{
	LABEL		"Select Positioner/Actuator Action";
	ITEMS
	{
		func3_AO_3_increase_close
	}
}

MENU Tab_s_fault_set_AO_3
{
	LABEL		"Set Fail Safe Values";
	ITEMS
	{
		func3_AO_3_fsafe_type,
		func3_AO_3_fsafe_time,
		func3_AO_3_fsafe_value
	}
}

MENU Tab_s_batch_AO_3
{
	LABEL		"Define Batch Information";
	ITEMS
	{
		func3_AO_3_batch_id,
		func3_AO_3_batch_unit,
		func3_AO_3_batch_operation,
		func3_AO_3_batch_phase
	}
}

 /* AO 4 */

MENU Page_diagnosis_func3_AO_4
{
    LABEL        "AO-4";
    ITEMS
    {
        func3_AO_4_blk_object,
        func3_AO_4_blk_parent_class,
        func3_AO_4_blk_class,
        func3_AO_4_blk_dd_reference,
        func3_AO_4_blk_dd_rev,
        func3_AO_4_blk_profile,
        func3_AO_4_blk_profile_rev,
        func3_AO_4_st_rev,
        func3_AO_4_actual_mode,
        func3_AO_4_simulation_enabled (READ_ONLY)
    }
}

MENU OfflineWindow_AO_4_geral
{
	LABEL "AO-4"; 
	ITEMS
	{
		Page_basic_AO_4,
		Page_scale_AO_4,
		Page_advanced_AO_4
	}
}

MENU Page_basic_AO_4
{
	LABEL [MC_Tab_basic];
	ITEMS
	{
		Group_target_mode_AO_4,
//		Group_channel_in_AO_4,
		Group_channel_out_AO_4,
		Group_direction_AO_4
	}
}

MENU Page_scale_AO_4
{
	LABEL "Scales/Units";
	ITEMS
	{
		Group_scale_pv_AO_4,
		Group_scale_out_AO_4
	}
}

MENU Page_advanced_AO_4
{
	LABEL [MC_Tab_advanced];
	ITEMS
	{
		Group_fault_set_AO_4,
		Group_batch_AO_4
	}
}

MENU Page_batch_AO_4
{
	LABEL [MC_Batch_Info];
	ITEMS
	{
		Group_batch_AO_4
	}
}


MENU Group_target_mode_AO_4
{
	LABEL "Config Block Mode";
	ITEMS
	{
		func3_AO_4_target_mode,
		COLUMNBREAK,
		method_write_target_mode_AO_4
	}
}

//MENU Group_channel_in_AO_4
//{
//	LABEL		"Select Channel";
//	ITEMS
//	{
//		func3_AO_4_in_channel,
//		COLUMNBREAK,
//		method_write_channel_in_out_AO_4
//	}
//}

MENU Group_channel_out_AO_4
{
	LABEL		"Select Channel";
	ITEMS
	{
		func3_AO_4_out_channel,
		COLUMNBREAK,
		method_write_channel_in_out_AO_4
	}
}

MENU Group_scale_pv_AO_4
{
	LABEL 	"Set Scale of Input Value";
	ITEMS
	{
		func3_AO_4_pv_upper_range_value,
		func3_AO_4_pv_lower_range_value,
		func3_AO_4_pv_unit,
		COLUMNBREAK,
		method_write_scale_in_AO_4
	}
}

MENU Group_scale_out_AO_4
{
	LABEL 	"Set Scale of Output Value";
	ITEMS
	{
		func3_AO_4_out_upper_range_value,
		func3_AO_4_out_lower_range_value,
		func3_AO_4_out_unit (READ_ONLY),
		COLUMNBREAK,
		method_write_scale_out_AO_4
	}
}

MENU Group_direction_AO_4
{
	LABEL		"Select Positioner/Actuator Action";
	ITEMS
	{
		func3_AO_4_increase_close,
		COLUMNBREAK,
		method_write_direction_AO_4
	}
}


MENU Group_fault_set_AO_4
{
	LABEL 	"Set Fail Safe Values";
	ITEMS
	{
		func3_AO_4_fsafe_type,
		func3_AO_4_fsafe_value,
		func3_AO_4_fsafe_time,
		COLUMNBREAK,
		method_write_fail_AO_4
	}
}

MENU Group_batch_AO_4
{
	LABEL		"Define Batch Information";
	ITEMS
	{
		func3_AO_4_batch_id,
		func3_AO_4_batch_unit,
		func3_AO_4_batch_operation,
		func3_AO_4_batch_phase,
		COLUMNBREAK,
		method_write_batch_AO_4
	}
}

MENU OnlineDialog_AO_4_setting
{
	LABEL		"AO-4 Block Mode";
	ITEMS
	{
		Page_mode_AO_4,
		Page_actuator_AO_4,
/*		Page_simulation_AO_4 */
	}
}

MENU Page_mode_AO_4
{
	LABEL		"Config Block Mode";
	ITEMS
	{
		Group_mode_AO_4,
		Group_output_AO_4,
		Group_setpoint_AO_4,
		Group_rcas_in_AO_4,
		Group_rcas_out_AO_4,
/*		Group_set_desv_AO_4, 
		Group_readback_AO_4,*/
		method_set
	}
}


MENU Group_mode_AO_4
{
	LABEL		"Config Block Mode";
	ITEMS
	{
		func3_AO_4_target_mode,
		COLUMNBREAK,
		func3_AO_4_actual_mode
	}
}

MENU Group_output_AO_4
{
	LABEL		"Set Output (MAN)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_4_out_value,
		COLUMNBREAK,
		func3_AO_4_out_status_quality,
        func3_AO_4_out_status_limit
	}
}

MENU Group_setpoint_AO_4
{
	LABEL		"Set Setpoint from Operator - SP (AUTO)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_4_setpoint_value,
		COLUMNBREAK,
		func3_AO_4_setpoint_status_quality,
        func3_AO_4_setpoint_status_limit
	}
}

MENU Group_rcas_in_AO_4
{
	LABEL		"Set Setpoint from Remote Station - RCAS_IN (RCAS)"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_4_rcas_in_value,
		COLUMNBREAK,
		func3_AO_4_rcas_in_status_quality,
        func3_AO_4_rcas_in_status_limit
	}
}

MENU Group_rcas_out_AO_4
{
	LABEL		"From RCAS_OUT to Remote Station"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_4_rcas_out_value,
		COLUMNBREAK,
		func3_AO_4_rcas_out_status_quality,
        func3_AO_4_rcas_out_status_limit
	}
}

MENU Group_set_desv_AO_4
{
	LABEL		[func_ao_setpoint_deviation]; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_4_setpoint_deviation
	}
}

MENU Page_actuator_AO_4
{
	LABEL		"Feedback";
	ITEMS
	{
		Group_readback_AO_4,
		Group_pos_d_AO_4,
		Group_set_desv_AO_4,
		func3_AO_4_check_back,
		func3_AO_4_current_state_alarm_sum
	}
}

MENU Group_pos_d_AO_4
{
	LABEL 		"Discrete Valve Position";
	ITEMS
	{
		func3_AO_4_position_discrete_value,
		COLUMNBREAK,
		func3_AO_4_position_discrete_status_quality,
        func3_AO_4_position_discrete_status_limit
	}
}

MENU Group_readback_AO_4
{
	LABEL		"Readback to Transducer"; /* [func_out_value]; */
	ITEMS
	{
		func3_AO_4_readback_value,
		COLUMNBREAK,
		func3_AO_4_readback_status_quality,
        func3_AO_4_readback_status_limit
	}
}

MENU OnlineDialog_simulation_AO_4
{
	LABEL		"Simulate AO-4"; /* "Simulate AI"; */
	ITEMS
	{
		Page_simulation_AO_4,
		Page_simulation_out_AO_4
	}
}

MENU Page_simulation_AO_4
{
	LABEL		[menu_dialog_simulation_input];
	ITEMS
	{
		func3_AO_4_simulation_enabled,
		Group_simulate_value_AO_4,
		method_set
	}
}

MENU Group_simulate_value_AO_4
{
	LABEL 	"Simulation Value";
	ITEMS
	{
		func3_AO_4_simulate_value,
		COLUMNBREAK,
		func3_AO_4_simulate_status_quality,
        func3_AO_4_simulate_status_limit
	}
}

MENU Page_simulation_out_AO_4
{
	LABEL		[menu_dialog_simulation_output];
	ITEMS
	{
		Group_mode_AO_4,
		Group_readback_AO_4,
		method_set
	}
}

METHOD method_set_status_limit_func3_AO_4
{
	CLASS		INPUT;
	DEFINITION
	{
		int	quality;
		int block_mode;			/* !!! temp.: bis Methoden mit Aufrufparametern funktionieren !!! */

		quality = ivar_value(func3_AO_4_setpoint_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_4_setpoint_status_limit, 0);

		quality = ivar_value(func3_AO_4_rcas_in_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_4_rcas_in_status_limit, 0);

		quality = ivar_value(func3_AO_4_simulate_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_AO_4_simulate_status_limit, 0);

		block_mode	= ivar_value(func3_AO_4_target_mode);
		quality		= ivar_value(func3_AO_4_out_status_quality);
		if (((block_mode == BLOCK_MODE_MAN) || (block_mode == BLOCK_MODE_LO)) && ((quality == 0x20) || (quality == 0x30)))
			iassign(func3_AO_4_out_status_limit, 0);
	}
}

METHOD method_write_target_mode_AO_4
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_4_target_mode);
		ReadCommand(read_func3_AO_4_target_mode);
	}
}

METHOD method_write_channel_in_out_AO_4
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_4_out_channel);
		ReadCommand(read_func3_AO_4_out_channel);
		sassign(func3_AO_4_in_channel, func3_AO_4_out_channel);
		WriteCommand(write_func3_AO_4_in_channel);
		ReadCommand(read_func3_AO_4_in_channel);
	}
}

//METHOD method_write_channel_out_AO_4
//{
//	LABEL "Write";
//	DEFINITION
//	{
//		WriteCommand(write_func3_AO_4_out_channel);
//		ReadCommand(read_func3_AO_4_out_channel);
//	}
//}

METHOD method_write_direction_AO_4
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_4_increase_close);
		ReadCommand(read_func3_AO_4_increase_close);
	}
}


METHOD method_write_scale_in_AO_4
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_4_pv);
		ReadCommand(read_func3_AO_4_pv);
	}
}

METHOD method_write_scale_out_AO_4
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_4_out_scale);
		ReadCommand(read_func3_AO_4_out_scale);
	}
}

METHOD method_write_fail_AO_4
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_4_fsafe_type);
		WriteCommand(write_func3_AO_4_fsafe_time);
		WriteCommand(write_func3_AO_4_fsafe_value);
		ReadCommand(read_func3_AO_4_fsafe_type);
		ReadCommand(read_func3_AO_4_fsafe_time);
		ReadCommand(read_func3_AO_4_fsafe_value);
	}
}

METHOD method_write_batch_AO_4
{
	LABEL "Write";
	DEFINITION
	{
		WriteCommand(write_func3_AO_4_batch_information);
	}
}


/* windows */

MENU Page_display_AO_4
{
	LABEL		"AO-4";
	ITEMS
	{
		BarVal_display_readback_AO_4,
		Group_display_readback_AO_4
		Group_display_setpoint_AO_4,
		func3_AO_4_position_discrete_value,
		func3_AO_4_setpoint_deviation,
		func3_AO_4_check_back,
//		BarVal_display_out_AO_4,
		Group_display_out_AO_4
	}
}

MENU BarVal_display_readback_AO_4
{
	LABEL		"Readback to Transducer";
	ITEMS
	{
		func3_AO_4_readback_value,
		func3_AO_4_pv_lower_range_value		(READ_ONLY),
		func3_AO_4_pv_upper_range_value		(READ_ONLY)
	}
}

MENU Group_display_readback_AO_4
{
	LABEL		"Readback to Transducer";
	ITEMS
	{
		func3_AO_4_readback_value,
		COLUMNBREAK,
		func3_AO_4_readback_status_quality,
        func3_AO_4_readback_status_limit
	}
}

MENU Group_display_setpoint_AO_4
{
	LABEL		[func_ao_setpoint_value];
	ITEMS
	{
		func3_AO_4_setpoint_value			(READ_ONLY),
		COLUMNBREAK,
		func3_AO_4_setpoint_status_quality (READ_ONLY),
		func3_AO_4_setpoint_status_limit   (READ_ONLY)
	}
}

MENU BarVal_display_out_AO_4
{
	LABEL			"Output";
	ITEMS
	{
		func3_AO_4_out_value					(READ_ONLY),
		func3_AO_4_out_lower_range_value		(READ_ONLY),
		func3_AO_4_out_upper_range_value		(READ_ONLY)
	}
}

MENU Group_display_out_AO_4
{
	LABEL			"Output";
	ITEMS
	{
		func3_AO_4_out_value					(READ_ONLY),
		COLUMNBREAK,
		func3_AO_4_out_status_quality (READ_ONLY),
		func3_AO_4_out_status_limit   (READ_ONLY)
	}
}

/* Menus */

MENU Tab_s_AO_4
{
	LABEL		"AO-4";
	ITEMS
	{
        func3_AO_4_st_rev,
		Tab_s_basic_AO_4,
		Tab_s_advanced_AO_4
	}
}

MENU Tab_s_basic_AO_4
{
	LABEL        [MC_Tab_basic];
	ITEMS
	{
		Tab_s_target_mode_AO_4,
//		Tab_s_channel_in_AO_4,
		Tab_s_channel_out_AO_4,
		Tab_s_direction_AO_4,
		Tab_s_scale_pv_AO_4,
		Tab_s_scale_out_AO_4
	}
}

MENU Tab_s_advanced_AO_4
{
	LABEL        [MC_Tab_advanced];
	ITEMS
	{
		Tab_s_fault_set_AO_4,
		Tab_s_batch_AO_4
	}
}

MENU Tab_s_target_mode_AO_4
{
	LABEL		[MC_Tab_mode_ao];
	ITEMS
	{
		func3_AO_4_target_mode
	}
}

//MENU Tab_s_channel_in_AO_4
//{
//	LABEL		"Select Input";
//	ITEMS
//	{
//		func3_AO_4_in_channel
//	}
//}

MENU Tab_s_channel_out_AO_4
{
	LABEL		"Select Channel";
	ITEMS
	{
		func3_AO_4_out_channel
	}
}

MENU 	Tab_s_scale_pv_AO_4
{
	LABEL "Set Scale of Input Value";
	ITEMS
	{
		func3_AO_4_pv_upper_range_value,
		func3_AO_4_pv_lower_range_value,
		func3_AO_4_pv_unit
	}
}

MENU 	Tab_s_scale_out_AO_4
{
	LABEL "Set Scale of Output Value";
	ITEMS
	{
		func3_AO_4_out_upper_range_value,
		func3_AO_4_out_lower_range_value,
		func3_AO_4_out_unit(READ_ONLY)
	}
}

MENU Tab_s_direction_AO_4
{
	LABEL		"Select Positioner/Actuator Action";
	ITEMS
	{
		func3_AO_4_increase_close
	}
}

MENU Tab_s_fault_set_AO_4
{
	LABEL		"Set Fail Safe Values";
	ITEMS
	{
		func3_AO_4_fsafe_type,
		func3_AO_4_fsafe_time,
		func3_AO_4_fsafe_value
	}
}

MENU Tab_s_batch_AO_4
{
	LABEL		"Define Batch Information";
	ITEMS
	{
		func3_AO_4_batch_id,
		func3_AO_4_batch_unit,
		func3_AO_4_batch_operation,
		func3_AO_4_batch_phase
	}
}

